/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.hotels.styx.api.Buffer;
import com.hotels.styx.api.ContentOverflowException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class ByteStreamAggregator
implements Subscriber<Buffer> {
    private final Publisher<Buffer> upstream;
    private final int maxSize;
    private final CompletableFuture<Buffer> future = new CompletableFuture();
    private final AtomicBoolean active = new AtomicBoolean();
    private final CompositeByteBuf aggregated = Unpooled.compositeBuffer();
    private Subscription subscription;

    ByteStreamAggregator(Publisher<Buffer> upstream, int maxSize) {
        this.upstream = Objects.requireNonNull(upstream);
        this.maxSize = maxSize;
    }

    public CompletableFuture<Buffer> apply() {
        if (this.active.compareAndSet(false, true)) {
            this.upstream.subscribe((Subscriber)this);
            return this.future;
        }
        throw new IllegalStateException("ByteStreamAggregator may only be started once.");
    }

    public void onSubscribe(Subscription subscription) {
        if (this.subscription != null) {
            subscription.cancel();
            throw new IllegalStateException("ByteStreamAggregator supports only one Producer instance.");
        }
        this.subscription = subscription;
        this.subscription.request(Long.MAX_VALUE);
    }

    public void onNext(Buffer part) {
        long newSize = this.aggregated.readableBytes() + part.size();
        if (newSize > (long)this.maxSize) {
            part.delegate().release();
            this.aggregated.release();
            this.subscription.cancel();
            this.future.completeExceptionally(new ContentOverflowException(String.format("Maximum content size exceeded. Maximum size allowed is %d bytes.", this.maxSize)));
        } else {
            this.aggregated.addComponent(part.delegate());
            this.aggregated.writerIndex(this.aggregated.writerIndex() + part.size());
        }
    }

    public void onError(Throwable cause) {
        this.aggregated.release();
        this.subscription.cancel();
        this.future.completeExceptionally(cause);
    }

    public void onComplete() {
        this.future.complete(new Buffer((ByteBuf)this.aggregated));
    }
}

