/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.google.common.collect.ImmutableSet;
import com.hotels.styx.api.Buffer;
import com.hotels.styx.api.ByteStream;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpHeaderValues;
import com.hotels.styx.api.HttpHeaders;
import com.hotels.styx.api.HttpMessage;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.HttpVersion;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.api.ResponseCookie;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class HttpResponse
implements HttpMessage {
    private final HttpVersion version;
    private final HttpResponseStatus status;
    private final HttpHeaders headers;
    private final byte[] body;

    private HttpResponse(Builder builder) {
        this.version = builder.version;
        this.status = builder.status;
        this.headers = builder.headers.build();
        this.body = Objects.requireNonNull(builder.body);
    }

    public static Builder response() {
        return new Builder();
    }

    public static Builder response(HttpResponseStatus status) {
        return new Builder(status);
    }

    @Override
    public Optional<String> header(CharSequence name) {
        return this.headers.get(name);
    }

    @Override
    public List<String> headers(CharSequence name) {
        return this.headers.getAll(name);
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public byte[] body() {
        return (byte[])this.body.clone();
    }

    @Override
    public String bodyAs(Charset charset) {
        return new String(this.body, charset);
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public HttpResponseStatus status() {
        return this.status;
    }

    public boolean isRedirect() {
        return this.status.code() >= 300 && this.status.code() < 400;
    }

    public LiveHttpResponse stream() {
        if (this.body.length == 0) {
            return new LiveHttpResponse.Builder(this, new ByteStream((Publisher<Buffer>)Flux.empty())).build();
        }
        return new LiveHttpResponse.Builder(this, new ByteStream((Publisher<Buffer>)Flux.just((Object)new Buffer(Unpooled.copiedBuffer((byte[])this.body))))).build();
    }

    public Set<ResponseCookie> cookies() {
        return ResponseCookie.decode(this.headers.getAll(HttpHeaderNames.SET_COOKIE));
    }

    public Optional<ResponseCookie> cookie(String name) {
        return this.cookies().stream().filter(cookie -> cookie.name().equals(name)).findFirst();
    }

    public String toString() {
        return "{version=" + this.version + ", status=" + this.status + "}";
    }

    public int hashCode() {
        return Objects.hash(this.version, this.status, this.headers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HttpResponse other = (HttpResponse)obj;
        return Objects.equals(this.version, other.version) && Objects.equals(this.status, other.status) && Objects.equals(this.headers, other.headers);
    }

    public static final class Builder {
        private HttpResponseStatus status = HttpResponseStatus.OK;
        private HttpHeaders.Builder headers;
        private HttpVersion version = HttpVersion.HTTP_1_1;
        private boolean validate = true;
        private byte[] body;

        public Builder() {
            this.headers = new HttpHeaders.Builder();
            this.body = new byte[0];
        }

        public Builder(HttpResponseStatus status) {
            this();
            this.status = status;
        }

        public Builder(HttpResponse response) {
            this.status = response.status();
            this.version = response.version();
            this.headers = response.headers().newBuilder();
            this.body = response.body();
        }

        public Builder(LiveHttpResponse response, byte[] body) {
            this.status = response.status();
            this.version = response.version();
            this.headers = response.headers().newBuilder();
            this.body = body;
        }

        public Builder status(HttpResponseStatus status) {
            this.status = status;
            return this;
        }

        public Builder body(String content, Charset charset) {
            return this.body(content, charset, true);
        }

        public Builder body(String content, Charset charset, boolean setContentLength) {
            Objects.requireNonNull(charset, "Charset is not provided.");
            String sanitised = content == null ? "" : content;
            return this.body(sanitised.getBytes(charset), setContentLength);
        }

        public Builder body(byte[] content, boolean setContentLength) {
            byte[] byArray = this.body = content == null ? new byte[]{} : (byte[])content.clone();
            if (setContentLength) {
                this.header(HttpHeaderNames.CONTENT_LENGTH, this.body.length);
            }
            return this;
        }

        public Builder version(HttpVersion version) {
            this.version = Objects.requireNonNull(version);
            return this;
        }

        public Builder disableCaching() {
            this.header("Pragma", "no-cache");
            this.header("Expires", "Mon, 1 Jan 2007 08:00:00 GMT");
            this.header("Cache-Control", "no-cache,must-revalidate,no-store");
            return this;
        }

        public Builder setChunked() {
            this.headers.add(HttpHeaderNames.TRANSFER_ENCODING, HttpHeaderValues.CHUNKED);
            this.headers.remove(HttpHeaderNames.CONTENT_LENGTH);
            return this;
        }

        public Builder cookies(ResponseCookie ... cookies) {
            return this.cookies(Arrays.asList(cookies));
        }

        public Builder cookies(Collection<ResponseCookie> cookies) {
            Objects.requireNonNull(cookies);
            this.headers.remove(HttpHeaderNames.SET_COOKIE);
            return this.addCookies(cookies);
        }

        public Builder addCookies(ResponseCookie ... cookies) {
            return this.addCookies(Arrays.asList(cookies));
        }

        public Builder addCookies(Collection<ResponseCookie> cookies) {
            Objects.requireNonNull(cookies);
            if (cookies.isEmpty()) {
                return this;
            }
            this.removeCookies(cookies.stream().map(ResponseCookie::name).collect(Collectors.toList()));
            ResponseCookie.encode(cookies).forEach(cookie -> this.addHeader(HttpHeaderNames.SET_COOKIE, cookie));
            return this;
        }

        public Builder removeCookies(String ... names) {
            return this.removeCookies(Arrays.asList(names));
        }

        public Builder removeCookies(Collection<String> names) {
            Objects.requireNonNull(names);
            if (names.isEmpty()) {
                return this;
            }
            return this.removeCookiesIf(Builder.toSet(names)::contains);
        }

        private Builder removeCookiesIf(Predicate<String> removeIfName) {
            Predicate<ResponseCookie> keepIf = cookie -> !removeIfName.test(cookie.name());
            List<ResponseCookie> newCookies = ResponseCookie.decode(this.headers.getAll(HttpHeaderNames.SET_COOKIE)).stream().filter(keepIf).collect(Collectors.toList());
            return this.cookies(newCookies);
        }

        private static <T> Set<T> toSet(Collection<T> collection) {
            return collection instanceof Set ? (Set)collection : ImmutableSet.copyOf(collection);
        }

        public Builder header(CharSequence name, Object value) {
            this.headers.set(name, value);
            return this;
        }

        public Builder addHeader(CharSequence name, Object value) {
            this.headers.add(name, value);
            return this;
        }

        public Builder removeHeader(CharSequence name) {
            this.headers.remove(name);
            return this;
        }

        public Builder headers(HttpHeaders headers) {
            this.headers = headers.newBuilder();
            return this;
        }

        public Builder disableValidation() {
            this.validate = false;
            return this;
        }

        public HttpResponse build() {
            if (this.validate) {
                this.ensureContentLengthIsValid();
            }
            return new HttpResponse(this);
        }

        Builder ensureContentLengthIsValid() {
            List<String> contentLengths = this.headers.build().getAll(HttpHeaderNames.CONTENT_LENGTH);
            if (contentLengths.size() > 1) {
                throw new IllegalArgumentException(String.format("Duplicate Content-Length found. %s", contentLengths));
            }
            if (contentLengths.size() == 1 && !Builder.isNonNegativeInteger(contentLengths.get(0))) {
                throw new IllegalArgumentException(String.format("Invalid Content-Length found. %s", contentLengths.get(0)));
            }
            return this;
        }

        private static boolean isNonNegativeInteger(String contentLength) {
            try {
                long value = Long.parseLong(contentLength);
                return value >= 0L;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

