/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.google.common.collect.ImmutableSet;
import com.hotels.styx.api.Buffer;
import com.hotels.styx.api.ByteStream;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpHeaderValues;
import com.hotels.styx.api.HttpHeaders;
import com.hotels.styx.api.HttpMessageSupport;
import com.hotels.styx.api.HttpMethod;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpVersion;
import com.hotels.styx.api.LiveHttpMessage;
import com.hotels.styx.api.RequestCookie;
import com.hotels.styx.api.Url;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class LiveHttpRequest
implements LiveHttpMessage {
    private final Object id;
    private final HttpVersion version;
    private final HttpMethod method;
    private final Url url;
    private final HttpHeaders headers;
    private final ByteStream body;

    LiveHttpRequest(Builder builder) {
        this.id = builder.id == null ? UUID.randomUUID() : builder.id;
        this.version = builder.version;
        this.method = builder.method;
        this.url = builder.url;
        this.headers = builder.headers.build();
        this.body = Objects.requireNonNull(builder.body);
    }

    public static Builder get(String uri) {
        return new Builder(HttpMethod.GET, uri);
    }

    public static Builder head(String uri) {
        return new Builder(HttpMethod.HEAD, uri);
    }

    public static Builder post(String uri) {
        return new Builder(HttpMethod.POST, uri);
    }

    public static Builder delete(String uri) {
        return new Builder(HttpMethod.DELETE, uri);
    }

    public static Builder put(String uri) {
        return new Builder(HttpMethod.PUT, uri);
    }

    public static Builder patch(String uri) {
        return new Builder(HttpMethod.PATCH, uri);
    }

    public static Builder post(String uri, ByteStream body) {
        return new Builder(HttpMethod.POST, uri).body(body);
    }

    public static Builder put(String uri, ByteStream body) {
        return new Builder(HttpMethod.PUT, uri).body(body);
    }

    public static Builder patch(String uri, ByteStream body) {
        return new Builder(HttpMethod.PATCH, uri).body(body);
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public List<String> headers(CharSequence name) {
        return this.headers.getAll(name);
    }

    @Override
    public ByteStream body() {
        return this.body;
    }

    public Object id() {
        return this.id;
    }

    public HttpMethod method() {
        return this.method;
    }

    public Url url() {
        return this.url;
    }

    public String path() {
        return this.url.path();
    }

    public boolean keepAlive() {
        return HttpMessageSupport.keepAlive(this.headers, this.version);
    }

    public Optional<String> queryParam(String name) {
        return this.url.queryParam(name);
    }

    public Iterable<String> queryParams(String name) {
        return this.url.queryParams(name);
    }

    public Map<String, List<String>> queryParams() {
        return this.url.queryParams();
    }

    public Iterable<String> queryParamNames() {
        return this.url.queryParamNames();
    }

    public Transformer newBuilder() {
        return new Transformer(this);
    }

    public Eventual<HttpRequest> aggregate(int maxContentBytes) {
        return Eventual.from(this.body.aggregate(maxContentBytes).thenApply(it -> new HttpRequest.Builder(this, LiveHttpRequest.decodeAndRelease(it)).build()));
    }

    private static byte[] decodeAndRelease(Buffer aggregate) {
        try {
            byte[] byArray = ByteBufUtil.getBytes((ByteBuf)aggregate.delegate());
            return byArray;
        }
        finally {
            aggregate.delegate().release();
        }
    }

    public Set<RequestCookie> cookies() {
        return this.headers.get(HttpHeaderNames.COOKIE).map(RequestCookie::decode).orElseGet(Collections::emptySet);
    }

    public Optional<RequestCookie> cookie(String name) {
        return this.cookies().stream().filter(cookie -> cookie.name().equals(name)).findFirst();
    }

    public String toString() {
        return "{version=" + this.version + ", method=" + this.method + ", uri=" + this.url + ", id=" + this.id + "}";
    }

    public static final class Builder
    implements BuilderTransformer {
        private Object id;
        private HttpMethod method = HttpMethod.GET;
        private boolean validate = true;
        private Url url;
        private HttpHeaders.Builder headers;
        private HttpVersion version = HttpVersion.HTTP_1_1;
        private ByteStream body;

        public Builder() {
            this.url = Url.Builder.url("/").build();
            this.headers = new HttpHeaders.Builder();
            this.body = new ByteStream((Publisher<Buffer>)Flux.empty());
        }

        public Builder(HttpMethod method, String uri) {
            this();
            this.method = Objects.requireNonNull(method);
            this.url = Url.Builder.url(uri).build();
        }

        public Builder(LiveHttpRequest request, ByteStream contentStream) {
            this.id = request.id();
            this.method = HttpMethod.httpMethod(request.method().name());
            this.url = request.url();
            this.version = HttpVersion.httpVersion(request.version().toString());
            this.headers = request.headers().newBuilder();
            this.body = contentStream;
        }

        Builder(LiveHttpRequest request) {
            this.id = request.id();
            this.method = request.method();
            this.url = request.url();
            this.version = request.version();
            this.headers = request.headers().newBuilder();
            this.body = request.body();
        }

        Builder(HttpRequest request) {
            this.id = request.id();
            this.method = request.method();
            this.url = request.url();
            this.version = request.version();
            this.headers = request.headers().newBuilder();
            this.body = new ByteStream((Publisher<Buffer>)Flux.just((Object)new Buffer(Unpooled.copiedBuffer((byte[])request.body()))));
        }

        @Override
        public Builder uri(String uri) {
            return this.url(Url.Builder.url(uri).build());
        }

        public Builder body(ByteStream content) {
            this.body = content;
            return this;
        }

        @Override
        public Builder id(Object id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder header(CharSequence name, Object value) {
            this.headers.set(name, value);
            return this;
        }

        @Override
        public Builder headers(HttpHeaders headers) {
            this.headers = headers.newBuilder();
            return this;
        }

        @Override
        public Builder addHeader(CharSequence name, Object value) {
            this.headers.add(name, value);
            return this;
        }

        @Override
        public Builder removeHeader(CharSequence name) {
            this.headers.remove(name);
            return this;
        }

        @Override
        public Builder url(Url url) {
            this.url = url;
            return this;
        }

        @Override
        public Builder version(HttpVersion version) {
            this.version = Objects.requireNonNull(version);
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = Objects.requireNonNull(method);
            return this;
        }

        @Override
        public Builder disableValidation() {
            this.validate = false;
            return this;
        }

        @Override
        public Builder enableKeepAlive() {
            return this.header(HttpHeaderNames.CONNECTION, HttpHeaderValues.KEEP_ALIVE);
        }

        @Override
        public Builder cookies(RequestCookie ... cookies) {
            return this.cookies(Arrays.asList(cookies));
        }

        @Override
        public Builder cookies(Collection<RequestCookie> cookies) {
            Objects.requireNonNull(cookies);
            this.headers.remove(HttpHeaderNames.COOKIE);
            if (!cookies.isEmpty()) {
                this.header(HttpHeaderNames.COOKIE, RequestCookie.encode(cookies));
            }
            return this;
        }

        @Override
        public Builder addCookies(RequestCookie ... cookies) {
            return this.addCookies(Arrays.asList(cookies));
        }

        @Override
        public Builder addCookies(Collection<RequestCookie> cookies) {
            Objects.requireNonNull(cookies);
            Set<RequestCookie> currentCookies = RequestCookie.decode(this.headers.get(HttpHeaderNames.COOKIE));
            List newCookies = Stream.concat(cookies.stream(), currentCookies.stream()).collect(Collectors.toList());
            return this.cookies((Collection)newCookies);
        }

        @Override
        public Builder removeCookies(String ... names) {
            return this.removeCookies(Arrays.asList(names));
        }

        @Override
        public Builder removeCookies(Collection<String> names) {
            Objects.requireNonNull(names);
            return this.removeCookiesIf(Builder.toSet(names)::contains);
        }

        private Builder removeCookiesIf(Predicate<String> removeIfName) {
            Predicate<RequestCookie> keepIf = cookie -> !removeIfName.test(cookie.name());
            List newCookies = RequestCookie.decode(this.headers.get(HttpHeaderNames.COOKIE)).stream().filter(keepIf).collect(Collectors.toList());
            return this.cookies((Collection)newCookies);
        }

        private static <T> Set<T> toSet(Collection<T> collection) {
            return collection instanceof Set ? (Set)collection : ImmutableSet.copyOf(collection);
        }

        @Override
        public LiveHttpRequest build() {
            if (this.validate) {
                this.ensureContentLengthIsValid();
                this.requireNotDuplicatedHeader(HttpHeaderNames.COOKIE);
                this.ensureMethodIsValid();
                this.setHostHeader();
            }
            return new LiveHttpRequest(this);
        }

        private void setHostHeader() {
            this.url.authority().ifPresent(authority -> this.header(HttpHeaderNames.HOST, authority.hostAndPort()));
        }

        private void ensureMethodIsValid() {
            if (!this.isMethodValid()) {
                throw new IllegalArgumentException(String.format("Unrecognised HTTP method=%s", this.method));
            }
        }

        private boolean isMethodValid() {
            return HttpMethod.METHODS.contains(this.method);
        }

        private void ensureContentLengthIsValid() {
            this.requireNotDuplicatedHeader(HttpHeaderNames.CONTENT_LENGTH).ifPresent(contentLength -> {
                if (!Builder.isNonNegativeInteger(contentLength)) {
                    throw new IllegalArgumentException(String.format("Invalid Content-Length found. %s", contentLength));
                }
            });
        }

        private Optional<String> requireNotDuplicatedHeader(CharSequence headerName) {
            List<String> headerValues = this.headers.build().getAll(headerName);
            if (headerValues.size() > 1) {
                throw new IllegalArgumentException(String.format("Duplicate %s found. %s", headerName, headerValues));
            }
            return headerValues.isEmpty() ? Optional.empty() : Optional.of(headerValues.get(0));
        }

        private static boolean isNonNegativeInteger(String contentLength) {
            try {
                long value = Long.parseLong(contentLength);
                return value >= 0L;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }

    public static final class Transformer
    implements BuilderTransformer {
        private final Builder builder;

        public Transformer(LiveHttpRequest liveHttpRequest) {
            this.builder = new Builder(liveHttpRequest);
        }

        @Override
        public Transformer uri(String uri) {
            this.builder.uri(uri);
            return this;
        }

        public Transformer body(Function<ByteStream, ByteStream> transformation) {
            this.builder.body(transformation.apply(this.builder.body));
            return this;
        }

        @Override
        public Transformer id(Object id) {
            this.builder.id(id);
            return this;
        }

        @Override
        public Transformer header(CharSequence name, Object value) {
            this.builder.header(name, value);
            return this;
        }

        @Override
        public Transformer headers(HttpHeaders headers) {
            this.builder.headers(headers);
            return this;
        }

        @Override
        public Transformer addHeader(CharSequence name, Object value) {
            this.builder.addHeader(name, value);
            return this;
        }

        @Override
        public Transformer removeHeader(CharSequence name) {
            this.builder.removeHeader(name);
            return this;
        }

        @Override
        public Transformer url(Url url) {
            this.builder.url(url);
            return this;
        }

        @Override
        public Transformer version(HttpVersion version) {
            this.builder.version(version);
            return this;
        }

        @Override
        public Transformer disableValidation() {
            this.builder.disableValidation();
            return this;
        }

        @Override
        public Transformer enableKeepAlive() {
            this.builder.enableKeepAlive();
            return this;
        }

        @Override
        public Transformer cookies(RequestCookie ... cookies) {
            this.builder.cookies(cookies);
            return this;
        }

        @Override
        public Transformer cookies(Collection<RequestCookie> cookies) {
            this.builder.cookies((Collection)cookies);
            return this;
        }

        @Override
        public Transformer addCookies(RequestCookie ... cookies) {
            this.builder.addCookies(cookies);
            return this;
        }

        @Override
        public Transformer addCookies(Collection<RequestCookie> cookies) {
            this.builder.addCookies((Collection)cookies);
            return this;
        }

        @Override
        public Transformer removeCookies(String ... names) {
            this.builder.removeCookies(names);
            return this;
        }

        @Override
        public Transformer removeCookies(Collection<String> names) {
            this.builder.removeCookies((Collection)names);
            return this;
        }

        @Override
        public LiveHttpRequest build() {
            return this.builder.build();
        }
    }

    private static interface BuilderTransformer {
        public BuilderTransformer uri(String var1);

        public BuilderTransformer id(Object var1);

        public BuilderTransformer header(CharSequence var1, Object var2);

        public BuilderTransformer headers(HttpHeaders var1);

        public BuilderTransformer addHeader(CharSequence var1, Object var2);

        public BuilderTransformer removeHeader(CharSequence var1);

        public BuilderTransformer url(Url var1);

        public BuilderTransformer version(HttpVersion var1);

        public BuilderTransformer disableValidation();

        public BuilderTransformer enableKeepAlive();

        public BuilderTransformer cookies(RequestCookie ... var1);

        public BuilderTransformer cookies(Collection<RequestCookie> var1);

        public BuilderTransformer addCookies(RequestCookie ... var1);

        public BuilderTransformer addCookies(Collection<RequestCookie> var1);

        public BuilderTransformer removeCookies(String ... var1);

        public BuilderTransformer removeCookies(Collection<String> var1);

        public LiveHttpRequest build();
    }
}

