/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.extension;

import com.google.common.net.HostAndPort;
import com.hotels.styx.api.Id;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class Origin
implements Comparable<Origin> {
    private final Id applicationId;
    private final String host;
    private final int port;
    private final String hostAsString;
    private final Id originId;
    private final int hashCode;

    private Origin(Builder builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.hostAsString = Origin.string(this.host, this.port);
        this.applicationId = Objects.requireNonNull(builder.applicationId);
        this.originId = Objects.requireNonNull(builder.originId);
        this.hashCode = Objects.hash(this.applicationId, this.host, this.originId);
    }

    Origin(String originId, String host) {
        HostAndPort hostAndPort = HostAndPort.fromString((String)host);
        this.originId = Id.id(originId);
        this.host = hostAndPort.getHostText();
        this.port = hostAndPort.getPort();
        this.hostAsString = hostAndPort.toString();
        this.applicationId = Id.GENERIC_APP;
        this.hashCode = Objects.hash(this.host, this.originId);
    }

    public static Builder newOriginBuilder(String host, int port) {
        return new Builder(host, port);
    }

    public static Builder newOriginBuilder(Origin origin) {
        return new Builder(origin);
    }

    public static void checkThatOriginsAreDistinct(Collection<Origin> origins) {
        Set ids = origins.stream().map(Origin::id).collect(Collectors.toSet());
        if (ids.size() != origins.size()) {
            throw new IllegalArgumentException("Duplicate ids in " + origins);
        }
        Set hosts = origins.stream().map(Origin::hostAndPortString).collect(Collectors.toSet());
        if (hosts.size() != origins.size()) {
            throw new IllegalArgumentException("Duplicate host and port in " + origins);
        }
    }

    public Builder newBuilder() {
        return Origin.newOriginBuilder(this);
    }

    public String applicationInfo() {
        return this.applicationId.toString().toUpperCase() + "-" + this.hostAsString;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String hostAndPortString() {
        return this.hostAsString;
    }

    public Id applicationId() {
        return this.applicationId;
    }

    public Id id() {
        return this.originId;
    }

    String idAsString() {
        return this.originId.toString();
    }

    @Override
    public int compareTo(Origin other) {
        return this.hostAsString.compareTo(other.hostAsString);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Origin other = (Origin)obj;
        return Objects.equals(this.applicationId, other.applicationId) && Objects.equals(this.hostAsString, other.hostAsString) && Objects.equals(this.originId, other.originId);
    }

    public String toString() {
        return String.format("%s:%s:%s", this.applicationId, this.originId, this.hostAsString);
    }

    private static String string(String host, int port) {
        return HostAndPort.fromParts((String)host, (int)port).toString();
    }

    public static final class Builder {
        private final String host;
        private final int port;
        private Id applicationId = Id.GENERIC_APP;
        private Id originId = Id.id("anonymous-origin");

        private Builder(String host, int port) {
            this.host = Objects.requireNonNull(host);
            this.port = port;
        }

        private Builder(Origin origin) {
            this.host = origin.host;
            this.port = origin.port;
            this.applicationId = origin.applicationId;
            this.originId = origin.originId;
        }

        public Builder id(String id) {
            this.originId = Id.id(id);
            return this;
        }

        public Builder applicationId(Id applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = Id.id(applicationId);
            return this;
        }

        public Origin build() {
            return new Origin(this);
        }
    }
}

