/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.extension.service.spi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.hotels.styx.api.Id;
import com.hotels.styx.api.Identifiable;
import com.hotels.styx.api.extension.service.spi.Registry;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegistry<T extends Identifiable>
implements Registry<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRegistry.class);
    private final List<Registry.ChangeListener<T>> listeners = new CopyOnWriteArrayList<Registry.ChangeListener<T>>();
    private final AtomicReference<Iterable<T>> snapshot = new AtomicReference(Collections.emptyList());
    private final Predicate<Collection<T>> resourceConstraint;

    public AbstractRegistry() {
        this(any -> true);
    }

    public AbstractRegistry(Predicate<Collection<T>> resourceConstraint) {
        this.resourceConstraint = Objects.requireNonNull(resourceConstraint);
    }

    @Override
    public Iterable<T> get() {
        return this.snapshot.get();
    }

    protected void notifyListeners(Registry.Changes<T> changes) {
        LOG.info("notifying about services={} to listeners={}", changes, this.listeners);
        this.listeners.forEach(listener -> listener.onChange(changes));
    }

    @Override
    public Registry<T> addListener(Registry.ChangeListener<T> changeListener) {
        this.listeners.add(changeListener);
        changeListener.onChange(this.added(this.snapshot.get()));
        return this;
    }

    public void set(Iterable<T> newObjects) throws IllegalStateException {
        ImmutableList newSnapshot = ImmutableList.copyOf(newObjects);
        if (!this.resourceConstraint.test((Collection<ImmutableList>)newSnapshot)) {
            throw new IllegalStateException("Resource constraint failure");
        }
        Iterable<T> oldSnapshot = this.snapshot.get();
        this.snapshot.set((Iterable<T>)newSnapshot);
        Registry.Changes<T> changes = AbstractRegistry.changes(newSnapshot, oldSnapshot);
        if (!changes.isEmpty()) {
            this.notifyListeners(changes);
        }
    }

    private Registry.Changes<T> added(Iterable<T> ch) {
        return new Registry.Changes.Builder<T>().added(ch).build();
    }

    @Override
    public Registry<T> removeListener(Registry.ChangeListener<T> changeListener) {
        this.listeners.remove(changeListener);
        return this;
    }

    protected static <T extends Identifiable> Registry.Changes<T> changes(Iterable<T> newResources, Iterable<T> currentResources) {
        Map<Id, T> newIdsToResource = AbstractRegistry.mapById(newResources);
        Map<Id, T> currentIdsToResource = AbstractRegistry.mapById(currentResources);
        MapDifference diff = Maps.difference(newIdsToResource, currentIdsToResource);
        Map diffs = diff.entriesDiffering();
        return new Registry.Changes.Builder().added(diff.entriesOnlyOnLeft().values()).removed(diff.entriesOnlyOnRight().values()).updated(Maps.filterKeys(newIdsToResource, diffs::containsKey).values()).build();
    }

    private static <T extends Identifiable> Map<Id, T> mapById(Iterable<T> resources) {
        return StreamSupport.stream(resources.spliterator(), false).collect(Collectors.toMap(Identifiable::id, Function.identity()));
    }
}

