/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Mono;

public final class Eventual<T>
implements Publisher<T> {
    private final Publisher<T> publisher;

    public Eventual(Publisher<T> publisher) {
        this.publisher = publisher;
    }

    public static <T> Eventual<T> of(T value) {
        return Eventual.fromMono(Mono.just(value));
    }

    public static <T> Eventual<T> from(CompletionStage<T> completionStage) {
        return Eventual.fromMono(Mono.fromCompletionStage(completionStage));
    }

    public static <T> Eventual<T> error(Throwable error) {
        return Eventual.fromMono(Mono.error((Throwable)error));
    }

    private static <T> Eventual<T> fromMono(Mono<T> mono) {
        return new Eventual<T>(mono);
    }

    public <R> Eventual<R> map(Function<? super T, ? extends R> transformation) {
        return Eventual.fromMono(Mono.from(this.publisher).map(transformation));
    }

    public <R> Eventual<R> flatMap(Function<? super T, ? extends Eventual<? extends R>> transformation) {
        return Eventual.fromMono(Mono.from(this.publisher).flatMap(value -> Mono.from((Publisher)((Publisher)transformation.apply(value)))));
    }

    public Eventual<T> onError(Function<Throwable, ? extends Eventual<? extends T>> errorHandler) {
        return Eventual.fromMono(Mono.from(this.publisher).onErrorResume(value -> Mono.from((Publisher)((Publisher)errorHandler.apply((Throwable)value)))));
    }

    public CompletableFuture<T> asCompletableFuture() {
        return Mono.from(this.publisher).toFuture();
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        this.publisher.subscribe(subscriber);
    }
}

