/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.google.common.base.Throwables;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class FormData {
    private final Map<String, String> parameters;

    FormData(HttpPostRequestDecoder content) {
        Objects.requireNonNull(content);
        this.parameters = this.extractParameters(content);
        content.destroy();
    }

    private Map<String, String> extractParameters(HttpPostRequestDecoder content) {
        return content.getBodyHttpDatas().stream().filter(data -> data instanceof Attribute).map(data -> (Attribute)data).collect(Collectors.toMap(InterfaceHttpData::getName, attribute -> {
            try {
                return attribute.getValue();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }));
    }

    public Map<String, String> parameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public Optional<String> postParam(String key) {
        return Optional.ofNullable(this.parameters.get(key));
    }

    public String toString() {
        return this.parameters.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
    }
}

