/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.hotels.styx.api.HttpHeader;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class HttpHeaders
implements Iterable<HttpHeader> {
    private static final DateTimeFormatter RFC1123_DATE_FORMAT = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZone(ZoneOffset.UTC);
    private final DefaultHttpHeaders nettyHeaders;

    private HttpHeaders(Builder builder) {
        this.nettyHeaders = builder.nettyHeaders;
    }

    public Set<String> names() {
        return ImmutableSet.copyOf((Collection)this.nettyHeaders.names());
    }

    public Optional<String> get(CharSequence name) {
        return Optional.ofNullable(this.nettyHeaders.get(name));
    }

    public List<String> getAll(CharSequence name) {
        return ImmutableList.copyOf((Collection)this.nettyHeaders.getAll(name));
    }

    public boolean contains(CharSequence name) {
        return this.nettyHeaders.contains(name);
    }

    @Override
    public Iterator<HttpHeader> iterator() {
        return StreamSupport.stream(this.nettyHeaders.spliterator(), false).map(header -> HttpHeader.header((String)header.getKey(), (String)header.getValue())).iterator();
    }

    public void forEach(BiConsumer<String, String> consumer) {
        this.nettyHeaders.forEach(entry -> consumer.accept((String)entry.getKey(), (String)entry.getValue()));
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return Iterables.toString((Iterable)this.nettyHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HttpHeaders other = (HttpHeaders)obj;
        return Objects.equals(this.toString(), other.toString());
    }

    public static class Builder {
        private final DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders(false);

        public Builder() {
        }

        public Builder(HttpHeaders headers) {
            this.nettyHeaders.set((io.netty.handler.codec.http.HttpHeaders)headers.nettyHeaders);
        }

        public List<String> getAll(CharSequence name) {
            return this.nettyHeaders.getAll(name);
        }

        public String get(CharSequence name) {
            return this.nettyHeaders.get(name);
        }

        public Builder add(CharSequence name, String value) {
            this.nettyHeaders.add(name, (Object)Objects.requireNonNull(value));
            return this;
        }

        public Builder add(CharSequence name, Object value) {
            this.nettyHeaders.add(name, Objects.requireNonNull(value));
            return this;
        }

        public Builder add(CharSequence name, Iterable values) {
            this.nonNullValues(values).ifPresent(nonNullValues -> this.nettyHeaders.add(name, (Iterable)nonNullValues));
            return this;
        }

        private Optional<List<?>> nonNullValues(Iterable<?> values) {
            List list = StreamSupport.stream(values.spliterator(), false).filter(value -> value != null).collect(Collectors.toList());
            return list.isEmpty() ? Optional.empty() : Optional.of(list);
        }

        public Builder remove(CharSequence name) {
            this.nettyHeaders.remove(name);
            return this;
        }

        public Builder set(CharSequence name, String value) {
            this.nettyHeaders.set(name, (Object)value);
            return this;
        }

        public Builder set(CharSequence name, Instant value) {
            this.nettyHeaders.set(name, (Object)RFC1123_DATE_FORMAT.format(value));
            return this;
        }

        public Builder set(CharSequence name, Object value) {
            this.nettyHeaders.set(name, value);
            return this;
        }

        public Builder set(CharSequence name, Iterable values) {
            this.nonNullValues(values).ifPresent(nonNullValues -> this.nettyHeaders.set(name, (Iterable)nonNullValues));
            return this;
        }

        public Builder set(CharSequence name, int value) {
            this.nettyHeaders.set(name, (Object)value);
            return this;
        }

        public HttpHeaders build() {
            return new HttpHeaders(this);
        }
    }
}

