/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.hotels.styx.api.Buffer;
import com.hotels.styx.api.ByteStream;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpHeaderValues;
import com.hotels.styx.api.HttpHeaders;
import com.hotels.styx.api.HttpMessage;
import com.hotels.styx.api.HttpMessageSupport;
import com.hotels.styx.api.HttpMethod;
import com.hotels.styx.api.HttpVersion;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.RequestCookie;
import com.hotels.styx.api.Url;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class HttpRequest
implements HttpMessage {
    private final Object id;
    private final HttpVersion version;
    private final HttpMethod method;
    private final Url url;
    private final HttpHeaders headers;
    private final byte[] body;

    HttpRequest(Builder builder) {
        this.id = builder.id == null ? UUID.randomUUID() : builder.id;
        this.version = builder.version;
        this.method = builder.method;
        this.url = builder.url;
        this.headers = builder.headers.build();
        this.body = Objects.requireNonNull(builder.body);
    }

    public static Builder get(String uri) {
        return new Builder(HttpMethod.GET, uri);
    }

    public static Builder head(String uri) {
        return new Builder(HttpMethod.HEAD, uri);
    }

    public static Builder post(String uri) {
        return new Builder(HttpMethod.POST, uri);
    }

    public static Builder delete(String uri) {
        return new Builder(HttpMethod.DELETE, uri);
    }

    public static Builder put(String uri) {
        return new Builder(HttpMethod.PUT, uri);
    }

    public static Builder patch(String uri) {
        return new Builder(HttpMethod.PATCH, uri);
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public List<String> headers(CharSequence name) {
        return this.headers.getAll(name);
    }

    @Override
    public byte[] body() {
        return (byte[])this.body.clone();
    }

    @Override
    public String bodyAs(Charset charset) {
        return new String(this.body, charset);
    }

    public Object id() {
        return this.id;
    }

    public HttpMethod method() {
        return this.method;
    }

    public Url url() {
        return this.url;
    }

    public String path() {
        return this.url.path();
    }

    public boolean keepAlive() {
        return HttpMessageSupport.keepAlive(this.headers, this.version);
    }

    public Optional<String> queryParam(String name) {
        return this.url.queryParam(name);
    }

    public Iterable<String> queryParams(String name) {
        return this.url.queryParams(name);
    }

    public Map<String, List<String>> queryParams() {
        return this.url.queryParams();
    }

    public Iterable<String> queryParamNames() {
        return this.url.queryParamNames();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public LiveHttpRequest stream() {
        LiveHttpRequest.Builder streamingBuilder = new LiveHttpRequest.Builder(this).disableValidation();
        if (this.body.length == 0) {
            return streamingBuilder.body(new ByteStream((Publisher<Buffer>)Flux.empty())).build();
        }
        return streamingBuilder.body(new ByteStream((Publisher<Buffer>)Flux.just((Object)new Buffer(Unpooled.copiedBuffer((byte[])this.body))))).build();
    }

    public Set<RequestCookie> cookies() {
        return this.headers.get(HttpHeaderNames.COOKIE).map(RequestCookie::decode).orElseGet(Collections::emptySet);
    }

    public Optional<RequestCookie> cookie(String name) {
        return this.cookies().stream().filter(cookie -> cookie.name().equals(name)).findFirst();
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("version", (Object)this.version).add("method", (Object)this.method).add("uri", (Object)this.url).add("headers", (Object)this.headers).add("id", this.id).toString();
    }

    public static final class Builder {
        private Object id;
        private HttpMethod method = HttpMethod.GET;
        private boolean validate = true;
        private Url url;
        private HttpHeaders.Builder headers;
        private HttpVersion version = HttpVersion.HTTP_1_1;
        private byte[] body;

        public Builder() {
            this.url = Url.Builder.url("/").build();
            this.headers = new HttpHeaders.Builder();
            this.body = new byte[0];
        }

        public Builder(HttpMethod method, String uri) {
            this();
            this.method = Objects.requireNonNull(method);
            this.url = Url.Builder.url(uri).build();
        }

        public Builder(LiveHttpRequest request, byte[] body) {
            this.id = request.id();
            this.method = request.method();
            this.url = request.url();
            this.version = request.version();
            this.headers = request.headers().newBuilder();
            this.body = body;
        }

        Builder(HttpRequest request) {
            this.id = request.id();
            this.method = request.method();
            this.url = request.url();
            this.version = request.version();
            this.headers = request.headers().newBuilder();
            this.body = request.body();
        }

        public Builder uri(String uri) {
            return this.url(Url.Builder.url(uri).build());
        }

        public Builder body(String content, Charset charset) {
            return this.body(content, charset, true);
        }

        public Builder body(String content, Charset charset, boolean setContentLength) {
            Objects.requireNonNull(charset, "Charset is not provided.");
            String sanitised = content == null ? "" : content;
            return this.body(sanitised.getBytes(charset), setContentLength);
        }

        public Builder body(byte[] content, boolean setContentLength) {
            byte[] byArray = this.body = content != null ? (byte[])content.clone() : new byte[]{};
            if (setContentLength) {
                this.header(HttpHeaderNames.CONTENT_LENGTH, this.body.length);
            }
            return this;
        }

        public Builder id(Object id) {
            this.id = id;
            return this;
        }

        public Builder header(CharSequence name, Object value) {
            this.headers.set(name, value);
            return this;
        }

        public Builder headers(HttpHeaders headers) {
            this.headers = headers.newBuilder();
            return this;
        }

        public Builder addHeader(CharSequence name, Object value) {
            this.headers.add(name, value);
            return this;
        }

        public Builder removeHeader(CharSequence name) {
            this.headers.remove(name);
            return this;
        }

        public Builder url(Url url) {
            this.url = url;
            return this;
        }

        public Builder version(HttpVersion version) {
            this.version = Objects.requireNonNull(version);
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = Objects.requireNonNull(method);
            return this;
        }

        public Builder cookies(RequestCookie ... cookies) {
            return this.cookies(Arrays.asList(cookies));
        }

        public Builder cookies(Collection<RequestCookie> cookies) {
            Objects.requireNonNull(cookies);
            this.headers.remove(HttpHeaderNames.COOKIE);
            if (!cookies.isEmpty()) {
                this.header(HttpHeaderNames.COOKIE, RequestCookie.encode(cookies));
            }
            return this;
        }

        public Builder addCookies(RequestCookie ... cookies) {
            return this.addCookies(Arrays.asList(cookies));
        }

        public Builder addCookies(Collection<RequestCookie> cookies) {
            Objects.requireNonNull(cookies);
            Set<RequestCookie> currentCookies = RequestCookie.decode(this.headers.get(HttpHeaderNames.COOKIE));
            List<RequestCookie> newCookies = Stream.concat(cookies.stream(), currentCookies.stream()).collect(Collectors.toList());
            return this.cookies(newCookies);
        }

        public Builder removeCookies(String ... names) {
            return this.removeCookies(Arrays.asList(names));
        }

        public Builder removeCookies(Collection<String> names) {
            Objects.requireNonNull(names);
            return this.removeCookiesIf(Builder.toSet(names)::contains);
        }

        private Builder removeCookiesIf(Predicate<String> removeIfName) {
            Predicate<RequestCookie> keepIf = cookie -> !removeIfName.test(cookie.name());
            List<RequestCookie> newCookies = RequestCookie.decode(this.headers.get(HttpHeaderNames.COOKIE)).stream().filter(keepIf).collect(Collectors.toList());
            return this.cookies(newCookies);
        }

        private static <T> Set<T> toSet(Collection<T> collection) {
            return collection instanceof Set ? (Set)collection : ImmutableSet.copyOf(collection);
        }

        public Builder enableKeepAlive() {
            return this.header(HttpHeaderNames.CONNECTION, HttpHeaderValues.KEEP_ALIVE);
        }

        public Builder disableValidation() {
            this.validate = false;
            return this;
        }

        public HttpRequest build() {
            if (this.validate) {
                this.ensureContentLengthIsValid();
                this.requireNotDuplicatedHeader(HttpHeaderNames.COOKIE);
                this.ensureMethodIsValid();
                this.setHostHeader();
            }
            return new HttpRequest(this);
        }

        private void setHostHeader() {
            this.url.authority().ifPresent(authority -> this.header(HttpHeaderNames.HOST, authority.hostAndPort()));
        }

        private void ensureMethodIsValid() {
            Preconditions.checkArgument((boolean)this.isMethodValid(), (String)"Unrecognised HTTP method=%s", (Object[])new Object[]{this.method});
        }

        private boolean isMethodValid() {
            return HttpMethod.METHODS.contains(this.method);
        }

        private void ensureContentLengthIsValid() {
            this.requireNotDuplicatedHeader(HttpHeaderNames.CONTENT_LENGTH).ifPresent(contentLength -> Preconditions.checkArgument((boolean)Builder.isInteger(contentLength), (String)"Invalid Content-Length found. %s", (Object[])new Object[]{contentLength}));
        }

        private Optional<String> requireNotDuplicatedHeader(CharSequence headerName) {
            List<String> headerValues = this.headers.build().getAll(headerName);
            Preconditions.checkArgument((headerValues.size() <= 1 ? 1 : 0) != 0, (String)"Duplicate %s found. %s", (Object[])new Object[]{headerName, headerValues});
            return headerValues.isEmpty() ? Optional.empty() : Optional.of(headerValues.get(0));
        }

        private static boolean isInteger(String contentLength) {
            try {
                Integer.parseInt(contentLength);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

