/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HttpVersion {
    public static final HttpVersion HTTP_1_0 = new HttpVersion("HTTP/1.0");
    public static final HttpVersion HTTP_1_1 = new HttpVersion("HTTP/1.1");
    private static final Map<String, HttpVersion> VERSIONS = Stream.of(HTTP_1_0, HTTP_1_1).collect(Collectors.toMap(HttpVersion::toString, Function.identity()));
    private final String version;

    private HttpVersion(String version) {
        this.version = version;
    }

    public static HttpVersion httpVersion(String version) {
        Preconditions.checkArgument((boolean)VERSIONS.containsKey(version), (String)"No such HTTP version %s", (Object[])new Object[]{version});
        return VERSIONS.get(version);
    }

    public String toString() {
        return this.version;
    }

    public boolean isKeepAliveDefault() {
        return this != HTTP_1_0;
    }
}

