/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class RequestCookie {
    private final String name;
    private final String value;
    private final int hashCode;

    private RequestCookie(String name, String value) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name cannot be null or empty");
        Objects.requireNonNull(value, "value cannot be null");
        this.name = name;
        this.value = value;
        this.hashCode = Objects.hash(name, value);
    }

    public static RequestCookie requestCookie(String name, String value) {
        return new RequestCookie(name, value);
    }

    public static Set<RequestCookie> decode(String headerValue) {
        if (headerValue == null) {
            return Collections.emptySet();
        }
        return ServerCookieDecoder.LAX.decode(headerValue).stream().map(RequestCookie::convert).collect(Collectors.toSet());
    }

    public static String encode(Collection<RequestCookie> cookies) {
        Preconditions.checkArgument((!cookies.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create cookie header value from zero cookies");
        Set nettyCookies = cookies.stream().map(RequestCookie::convert).collect(Collectors.toSet());
        return ClientCookieEncoder.LAX.encode(nettyCookies);
    }

    private static Cookie convert(RequestCookie cookie) {
        return new DefaultCookie(cookie.name, cookie.value);
    }

    private static RequestCookie convert(Cookie nettyCookie) {
        String name = nettyCookie.name();
        String value = nettyCookie.wrap() ? RequestCookie.quote(nettyCookie.value()) : nettyCookie.value();
        return RequestCookie.requestCookie(name, value);
    }

    private static String quote(String value) {
        return "\"" + value + "\"";
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RequestCookie other = (RequestCookie)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
    }

    public String toString() {
        return this.name + "=" + this.value;
    }
}

