/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.QueryStringEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

final class UrlQuery {
    private final List<Parameter> parameters;
    private final String encodedQuery;

    private UrlQuery(List<Parameter> parameters) {
        this.parameters = Collections.unmodifiableList(new ArrayList<Parameter>(parameters));
        QueryStringEncoder encoder = new QueryStringEncoder("", StandardCharsets.UTF_8);
        parameters.forEach(parameter -> encoder.addParam(((Parameter)parameter).key, ((Parameter)parameter).value));
        this.encodedQuery = this.removeInitialCharacter(encoder.toString());
    }

    private String removeInitialCharacter(String encodedQuery) {
        return encodedQuery.isEmpty() ? "" : encodedQuery.substring(1);
    }

    Optional<String> parameterValue(String name) {
        return StreamSupport.stream(this.parameterValues(name).spliterator(), false).findFirst();
    }

    Iterable<String> parameterValues(String name) {
        return this.parameters().stream().filter(parameter -> ((Parameter)parameter).key.equals(name)).map(Parameter::value).collect(Collectors.toList());
    }

    List<Parameter> parameters() {
        return this.parameters;
    }

    Iterable<String> parameterNames() {
        return this.parameters().stream().map(Parameter::key).distinct().collect(Collectors.toList());
    }

    String encodedQuery() {
        return this.encodedQuery;
    }

    Builder newBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlQuery query = (UrlQuery)o;
        return Objects.equals(this.encodedQuery, query.encodedQuery);
    }

    public int hashCode() {
        return Objects.hash(this.encodedQuery);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("parameters", this.parameters).add("encodedQuery", (Object)this.encodedQuery).toString();
    }

    static class Builder {
        private List<Parameter> parameters;

        Builder() {
            this((String)null);
        }

        Builder(String rawQuery) {
            if (rawQuery != null) {
                this.populateParametersFrom(rawQuery);
            }
        }

        Builder(UrlQuery query) {
            this.parameters = new ArrayList<Parameter>(query.parameters());
        }

        private void populateParametersFrom(String rawQuery) {
            QueryStringDecoder decoder = new QueryStringDecoder(rawQuery, StandardCharsets.UTF_8, false);
            this.parameters = decoder.parameters().entrySet().stream().flatMap(entry -> {
                List values = (List)entry.getValue();
                return values.stream().map(value -> new Parameter((String)entry.getKey(), (String)value));
            }).collect(Collectors.toList());
        }

        Builder addParam(String name, String value) {
            if (this.parameters == null) {
                this.parameters = new ArrayList<Parameter>();
            }
            this.parameters.add(new Parameter(name, value));
            return this;
        }

        UrlQuery build() {
            return new UrlQuery(this.parameters == null ? Collections.emptyList() : this.parameters);
        }
    }

    static class Parameter {
        private final String key;
        private final String value;

        Parameter(String key, String value) {
            this.key = key;
            this.value = value;
        }

        String key() {
            return this.key;
        }

        String value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            return Objects.equals(this.key, parameter.key) && Objects.equals(this.value, parameter.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

