/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.configuration;

import com.hotels.styx.api.configuration.ConversionException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public interface Configuration {
    public static final Configuration EMPTY_CONFIGURATION = new Configuration(){

        @Override
        public <X> Optional<X> get(String key, Class<X> type) {
            return Optional.empty();
        }

        public String toString() {
            return "{}";
        }
    };

    default public Optional<String> get(String key) {
        return this.get(key, String.class);
    }

    public <X> Optional<X> get(String var1, Class<X> var2);

    default public <X> X as(Class<X> type) throws ConversionException {
        throw new ConversionException("Cannot convert self to " + type);
    }

    public static interface Context {
        public static final Context EMPTY_CONFIGURATION_CONTEXT = Collections::emptyMap;

        public Map<String, String> asMap();
    }

    public static class MapBackedConfiguration
    implements Configuration {
        private final Configuration parent;
        private final Map<String, Object> config = new HashMap<String, Object>();

        public MapBackedConfiguration() {
            this(EMPTY_CONFIGURATION);
        }

        public MapBackedConfiguration(Configuration parent) {
            this.parent = Objects.requireNonNull(parent);
        }

        public MapBackedConfiguration set(String key, Object object) {
            Objects.requireNonNull(key);
            this.config.put(key, object);
            return this;
        }

        @Override
        public <X> Optional<X> get(String key, Class<X> type) {
            Optional<Object> found = Optional.ofNullable(this.config.get(key)).map(type::cast);
            if (!found.isPresent()) {
                return this.parent.get(key, type);
            }
            return found;
        }

        public String toString() {
            return "{}";
        }
    }
}

