/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.extension.service;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.hotels.styx.api.extension.service.RewriteRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RewriteConfig
implements RewriteRule {
    private final String urlPattern;
    private final String replacement;
    private final Pattern compiledUrlPattern;
    private final Replacement preprocessedReplacement;

    public RewriteConfig(String urlPattern, String replacement) {
        this.urlPattern = urlPattern;
        this.replacement = replacement;
        this.compiledUrlPattern = Pattern.compile(urlPattern);
        this.preprocessedReplacement = new Replacement(replacement);
    }

    public String urlPattern() {
        return this.urlPattern;
    }

    public String replacement() {
        return this.replacement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RewriteConfig that = (RewriteConfig)o;
        if (!this.replacement.equals(that.replacement)) {
            return false;
        }
        return this.urlPattern.equals(that.urlPattern);
    }

    public int hashCode() {
        int result = this.urlPattern.hashCode();
        result = 31 * result + this.replacement.hashCode();
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("urlPattern", (Object)this.urlPattern).add("replacement", (Object)this.replacement).toString();
    }

    @Override
    public Optional<String> rewrite(String originalUri) {
        Matcher matcher = this.compiledUrlPattern.matcher(originalUri);
        if (matcher.matches()) {
            return Optional.of(this.preprocessedReplacement.substitute(matcher));
        }
        return Optional.empty();
    }

    private static class Replacement {
        private static final String REGEX = "\\$\\d+";
        private final List<Integer> placeholderNumbers;
        private final List<String> literals;

        public Replacement(String replacement) {
            this.placeholderNumbers = Replacement.placeholderNumbers(replacement);
            this.literals = Replacement.literals(replacement);
        }

        private String substitute(MatchResult matcher) {
            StringBuilder rewrittenUrl = new StringBuilder();
            for (int i = 0; i < this.placeholderNumbers.size(); ++i) {
                if (!this.literals.isEmpty()) {
                    rewrittenUrl.append(this.literals.get(i));
                }
                rewrittenUrl.append(matcher.group(this.placeholderNumbers.get(i)));
            }
            if (this.literals.size() > this.placeholderNumbers.size()) {
                rewrittenUrl.append(this.literals.get(this.literals.size() - 1));
            }
            return rewrittenUrl.toString();
        }

        private static List<String> literals(String replacement) {
            return ImmutableList.copyOf(Arrays.asList(replacement.split(REGEX)));
        }

        private static List<Integer> placeholderNumbers(String replacement) {
            Pattern pattern = Pattern.compile(REGEX);
            Matcher matcher = pattern.matcher(replacement);
            ArrayList<Integer> placeholderNumbers = new ArrayList<Integer>();
            while (matcher.find()) {
                String nextGroup = matcher.group();
                placeholderNumbers.add(Replacement.placeholderNumber(nextGroup));
            }
            return ImmutableList.copyOf(placeholderNumbers);
        }

        private static int placeholderNumber(String nextGroup) {
            return Integer.parseInt(Replacement.removeDollar(nextGroup));
        }

        private static String removeDollar(String group) {
            return group.substring(1);
        }
    }
}

