/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.extension.service.spi;

import com.google.common.collect.Iterables;
import com.hotels.styx.api.Environment;
import com.hotels.styx.api.Identifiable;
import com.hotels.styx.api.configuration.Configuration;
import com.hotels.styx.api.configuration.ServiceFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public interface Registry<T extends Identifiable>
extends Supplier<Iterable<T>> {
    public Registry<T> addListener(ChangeListener<T> var1);

    public Registry<T> removeListener(ChangeListener<T> var1);

    public CompletableFuture<ReloadResult> reload();

    public static class ReloadResult {
        private final Outcome outcome;
        private final String message;
        private final Throwable cause;

        private ReloadResult(Outcome outcome, String message, Throwable cause) {
            this.outcome = outcome;
            this.message = message;
            this.cause = cause;
        }

        public static ReloadResult reloaded(String message) {
            return new ReloadResult(Outcome.RELOADED, message, null);
        }

        public static ReloadResult failed(String message, Throwable cause) {
            return new ReloadResult(Outcome.FAILED, message, cause);
        }

        public static ReloadResult unchanged(String message) {
            return new ReloadResult(Outcome.UNCHANGED, message, null);
        }

        public Outcome outcome() {
            return this.outcome;
        }

        public String message() {
            return this.message;
        }

        public Optional<Throwable> cause() {
            return Optional.ofNullable(this.cause);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReloadResult that = (ReloadResult)o;
            return this.outcome == that.outcome && Objects.equals(this.message, that.message) && Objects.equals(this.cause, that.cause);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.outcome, this.message, this.cause});
        }

        public String toString() {
            return "ReloadResult{outcome=" + (Object)((Object)this.outcome) + ", message='" + this.message + '\'' + ", cause='" + this.cause + "'" + '}';
        }
    }

    public static enum Outcome {
        RELOADED,
        UNCHANGED,
        FAILED;

    }

    public static final class Changes<T extends Identifiable> {
        private final Iterable<T> added;
        private final Iterable<T> removed;
        private final Iterable<T> updated;

        private Changes(Builder builder) {
            this.added = Changes.nullToEmpty(builder.added);
            this.removed = Changes.nullToEmpty(builder.removed);
            this.updated = Changes.nullToEmpty(builder.updated);
        }

        private static <T> Iterable<T> nullToEmpty(Iterable iterable) {
            return iterable != null ? iterable : Collections.emptyList();
        }

        public Iterable<T> added() {
            return this.added;
        }

        public Iterable<T> removed() {
            return this.removed;
        }

        public Iterable<T> updated() {
            return this.updated;
        }

        public int hashCode() {
            return Objects.hash(this.added, this.removed, this.updated);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Changes other = (Changes)obj;
            return this.equal(this.added, other.added) && this.equal(this.removed, other.removed) && this.equal(this.updated, other.updated);
        }

        private boolean equal(Iterable<T> iterable1, Iterable<T> iterable2) {
            return Iterables.size(iterable1) == Iterables.size(iterable2) && this.containsAll(iterable1, iterable2);
        }

        private boolean containsAll(Iterable<T> iterable1, Iterable<T> iterable2) {
            for (Identifiable item : iterable2) {
                if (Iterables.contains(iterable1, (Object)item)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "Changes{added=" + this.added + ", removed=" + this.removed + ", updated=" + this.updated + '}';
        }

        public Iterable<T> addedAndUpdated() {
            return Iterables.concat(this.added, this.updated);
        }

        public boolean isEmpty() {
            return Iterables.isEmpty(this.added) && Iterables.isEmpty(this.removed) && Iterables.isEmpty(this.updated);
        }

        public static class Builder<T extends Identifiable> {
            private Iterable<T> added;
            private Iterable<T> removed;
            private Iterable<T> updated;

            public Builder<T> added(T ... added) {
                return this.added((Iterable<T>)Arrays.asList(added));
            }

            public Builder<T> added(Iterable<T> added) {
                this.added = Objects.requireNonNull(added);
                return this;
            }

            public Builder<T> removed(T ... added) {
                return this.removed((Iterable<T>)Arrays.asList(added));
            }

            public Builder<T> removed(Iterable<T> removed) {
                this.removed = Objects.requireNonNull(removed);
                return this;
            }

            public Builder<T> updated(T ... updated) {
                return this.updated((Iterable<T>)Arrays.asList(updated));
            }

            public Builder<T> updated(Iterable<T> updated) {
                this.updated = Objects.requireNonNull(updated);
                return this;
            }

            public Changes<T> build() {
                return new Changes(this);
            }
        }
    }

    public static interface ChangeListener<T extends Identifiable>
    extends EventListener {
        public void onChange(Changes<T> var1);
    }

    public static interface Factory<T extends Identifiable>
    extends ServiceFactory<Registry<T>> {
        @Override
        public Registry<T> create(Environment var1, Configuration var2);
    }
}

