/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.extension.service;

import java.util.Objects;

public class Certificate {
    private String alias;
    private String certificatePath;

    Certificate(String alias, String certificatePath) {
        this.alias = Objects.requireNonNull(alias);
        this.certificatePath = Objects.requireNonNull(certificatePath);
    }

    public static Certificate certificate(String alias, String certificatePath) {
        return new Builder().setAlias(alias).setCertificatePath(certificatePath).build();
    }

    private Certificate(Builder builder) {
        this.alias = builder.alias;
        this.certificatePath = builder.certificatePath;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getCertificatePath() {
        return this.certificatePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Certificate that = (Certificate)o;
        return Objects.equals(this.alias, that.alias) && Objects.equals(this.certificatePath, that.certificatePath);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.certificatePath);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("alias", (Object)this.alias).add("certificatePath", (Object)this.certificatePath).toString();
    }

    public static final class Builder {
        private String alias;
        private String certificatePath;

        private Builder() {
        }

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder setCertificatePath(String certificatePath) {
            this.certificatePath = certificatePath;
            return this;
        }

        public Certificate build() {
            return new Certificate(this);
        }
    }
}

