/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.DBProp;
import com.hp.hpl.jena.db.impl.DBPropGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.vocabulary.DB;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBPropDatabase
extends DBProp {
    public static final Node_URI dbEngineType = (Node_URI)DB.engineType.asNode();
    public static final Node_URI dbLayoutVersion = (Node_URI)DB.layoutVersion.asNode();
    public static final Node_URI dbDriverVersion = (Node_URI)DB.driverVersion.asNode();
    public static final Node_URI dbFormatDate = (Node_URI)DB.formatDate.asNode();
    public static final Node_URI dbGraph = (Node_URI)DB.graph.asNode();
    public static final Node_URI dbLongObjectLength = (Node_URI)DB.longObjectLength.asNode();
    public static final Node_URI dbIndexKeyLength = (Node_URI)DB.indexKeyLength.asNode();
    public static final Node_URI dbIsTransactionDb = (Node_URI)DB.isTransactionDb.asNode();
    public static final Node_URI dbDoCompressURI = (Node_URI)DB.doCompressURI.asNode();
    public static final Node_URI dbCompressURILength = (Node_URI)DB.compressURILength.asNode();
    public static final Node_URI dbTableNamePrefix = (Node_URI)DB.tableNamePrefix.asNode();
    public static final String dbSystemGraphName = "SystemGraph";
    protected static SimpleDateFormat dateFormat = null;
    static final Map1<DBPropGraph, String> graphToName = new Map1<DBPropGraph, String>(){

        @Override
        public String map1(DBPropGraph o) {
            return o.getName();
        }
    };

    public DBPropDatabase(SpecializedGraph g, String engineType, String driverVersion, String layoutVersion, String longObjectLength, String indexKeyLength, String isTransactionDb, String doCompressURI, String compressURILength, String tableNamePrefix) {
        super(g);
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        String today = dateFormat.format(new Date());
        if (engineType != null) {
            this.putPropString(dbEngineType, engineType);
        }
        if (driverVersion != null) {
            this.putPropString(dbDriverVersion, driverVersion);
        }
        this.putPropString(dbLayoutVersion, layoutVersion);
        this.putPropString(dbFormatDate, today);
        this.putPropString(dbLongObjectLength, longObjectLength);
        this.putPropString(dbIndexKeyLength, indexKeyLength);
        this.putPropString(dbIsTransactionDb, isTransactionDb);
        this.putPropString(dbDoCompressURI, doCompressURI);
        this.putPropString(dbCompressURILength, compressURILength);
        this.putPropString(dbTableNamePrefix, tableNamePrefix);
    }

    public DBPropDatabase(SpecializedGraph g, Node n) {
        super(g, n);
    }

    public DBPropDatabase(SpecializedGraph g) {
        super(g, DBPropDatabase.findDBPropNode(g));
    }

    public String getName() {
        return this.self.getURI();
    }

    public String getEngineType() {
        return this.getPropString(dbEngineType);
    }

    public String getDriverVersion() {
        return this.getPropString(dbDriverVersion);
    }

    public String getFormatDate() {
        return this.getPropString(dbFormatDate);
    }

    public String getLayoutVersion() {
        return this.getPropString(dbLayoutVersion);
    }

    public String getLongObjectLength() {
        return this.getPropString(dbLongObjectLength);
    }

    public String getIndexKeyLength() {
        return this.getPropString(dbIndexKeyLength);
    }

    public String getIsTransactionDb() {
        return this.getPropString(dbIsTransactionDb);
    }

    public String getDoCompressURI() {
        return this.getPropString(dbDoCompressURI);
    }

    public String getCompressURILength() {
        return this.getPropString(dbCompressURILength);
    }

    public String getTableNamePrefix() {
        return this.getPropString(dbTableNamePrefix);
    }

    public void addGraph(DBPropGraph g) {
        this.putPropNode(dbGraph, g.getNode());
    }

    public void removeGraph(DBPropGraph g) {
        SpecializedGraph.CompletionFlag complete = DBPropDatabase.newComplete();
        ExtendedIterator<Triple> matches2 = this.graph.find(this.self, dbGraph, g.getNode(), complete);
        if (matches2.hasNext()) {
            this.graph.delete((Triple)matches2.next(), complete);
            g.remove();
            matches2.close();
        }
    }

    public ExtendedIterator<DBPropGraph> getAllGraphs() {
        return this.graph.find(this.self, dbGraph, null, DBPropDatabase.newComplete()).mapWith(new MapToLSet());
    }

    public ExtendedIterator<String> getAllGraphNames() {
        return this.getAllGraphs().mapWith(graphToName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Node findDBPropNode(SpecializedGraph g) {
        Node res = null;
        ExtendedIterator<Triple> matches2 = g.find(null, dbEngineType, null, DBPropDatabase.newComplete());
        if (matches2.hasNext()) {
            try {
                res = ((Triple)matches2.next()).getSubject();
                if (matches2.hasNext()) {
                    res = null;
                }
                Node node = res;
                return node;
            }
            finally {
                matches2.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String findDBPropString(Node_URI predicate) {
        ExtendedIterator<Triple> it = this.graph.find(null, predicate, null, DBPropDatabase.newComplete());
        if (it.hasNext()) {
            try {
                String res = null;
                Node obj = ((Triple)it.next()).getObject();
                if (!it.hasNext()) {
                    res = obj.getLiteralLexicalForm();
                }
                String string = res;
                return string;
            }
            finally {
                it.close();
            }
        }
        return null;
    }

    public String getInitLongObjectLength() {
        return this.findDBPropString(dbLongObjectLength);
    }

    public String getInitIndexKeyLength() {
        return this.findDBPropString(dbIndexKeyLength);
    }

    public String getInitDoCompressURI() {
        return this.findDBPropString(dbDoCompressURI);
    }

    public String getInitCompressURILength() {
        return this.findDBPropString(dbCompressURILength);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapToLSet
    implements Map1<Triple, DBPropGraph> {
        private MapToLSet() {
        }

        @Override
        public DBPropGraph map1(Triple t) {
            return new DBPropGraph(DBPropDatabase.this.graph, t.getObject());
        }
    }
}

