/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.sparql.util.TranslationTable;

public class Syntax
extends Symbol {
    public static final Syntax syntaxSPARQL_10 = new Syntax("http://jena.hpl.hp.com/2003/07/query/SPARQL_10");
    public static final Syntax syntaxSPARQL_11 = new Syntax("http://jena.hpl.hp.com/2003/07/query/SPARQL_11");
    public static final Syntax syntaxSPARQL = syntaxSPARQL_10;
    public static final Syntax syntaxARQ = new Syntax("http://jena.hpl.hp.com/2003/07/query/ARQ");
    public static final Syntax syntaxRDQL = new Syntax("http://jena.hpl.hp.com/2003/07/query/RDQL");
    public static final Syntax syntaxAlgebra = new Syntax("http://jena.hpl.hp.com/2003/07/query/SPARQL_Algebra");
    public static TranslationTable querySyntaxNames = new TranslationTable(true);
    public static Syntax defaultSyntax;

    protected Syntax(String s) {
        super(s);
    }

    protected Syntax(Syntax s) {
        super(s);
    }

    public static Syntax make(String uri) {
        if (uri == null) {
            return null;
        }
        Symbol sym = Symbol.create(uri);
        if (sym.equals(syntaxARQ)) {
            return syntaxARQ;
        }
        if (sym.equals(syntaxRDQL)) {
            return syntaxRDQL;
        }
        if (sym.equals(syntaxSPARQL)) {
            return syntaxSPARQL;
        }
        if (sym.equals(syntaxSPARQL_10)) {
            return syntaxSPARQL_10;
        }
        if (sym.equals(syntaxSPARQL_11)) {
            return syntaxSPARQL_11;
        }
        if (sym.equals(syntaxAlgebra)) {
            return syntaxAlgebra;
        }
        return null;
    }

    public static Syntax guessQueryFileSyntax(String url) {
        return Syntax.guessQueryFileSyntax(url, syntaxSPARQL);
    }

    public static Syntax guessQueryFileSyntax(String url, Syntax defaultSyntax) {
        if (url.endsWith(".arq")) {
            return syntaxARQ;
        }
        if (url.endsWith(".rq")) {
            return syntaxSPARQL;
        }
        if (url.endsWith(".rdql")) {
            return syntaxRDQL;
        }
        if (url.endsWith(".sse")) {
            return syntaxAlgebra;
        }
        return defaultSyntax;
    }

    public static Syntax lookup(String s) {
        return (Syntax)querySyntaxNames.lookup(s);
    }

    static {
        querySyntaxNames.put("sparql", syntaxSPARQL);
        querySyntaxNames.put("sparql_10", syntaxSPARQL_10);
        querySyntaxNames.put("sparql_11", syntaxSPARQL_11);
        querySyntaxNames.put("arq", syntaxARQ);
        querySyntaxNames.put("rdql", syntaxRDQL);
        querySyntaxNames.put("alg", syntaxAlgebra);
        querySyntaxNames.put("op", syntaxAlgebra);
        defaultSyntax = syntaxSPARQL;
    }
}

