/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.RDFReaderF;
import com.hp.hpl.jena.shared.ConfigException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.NoReaderForLangException;
import java.util.Properties;

public class RDFReaderFImpl
implements RDFReaderF {
    private static final String GRDDLREADER = "com.hp.hpl.jena.grddl.GRDDLReader";
    private static final String TURTLEREADER = "com.hp.hpl.jena.n3.turtle.TurtleReader";
    protected static Properties langToClassName = null;
    protected static final String[] LANGS = new String[]{"RDF/XML", "RDF/XML-ABBREV", "N-TRIPLE", "N-TRIPLES", "N3", "TURTLE", "Turtle", "TTL", "GRDDL"};
    protected static final String[] DEFAULTREADERS = new String[]{"com.hp.hpl.jena.rdf.arp.JenaReader", "com.hp.hpl.jena.rdf.arp.JenaReader", "com.hp.hpl.jena.rdf.model.impl.NTripleReader", "com.hp.hpl.jena.rdf.model.impl.NTripleReader", "com.hp.hpl.jena.n3.turtle.TurtleReader", "com.hp.hpl.jena.n3.turtle.TurtleReader", "com.hp.hpl.jena.n3.turtle.TurtleReader", "com.hp.hpl.jena.n3.turtle.TurtleReader", "com.hp.hpl.jena.grddl.GRDDLReader"};
    protected static final String DEFAULTLANG = LANGS[0];
    protected static final String PROPNAMEBASE = "com.hp.hpl.jena.reader.";

    public RDFReader getReader() {
        return this.getReader(DEFAULTLANG);
    }

    public RDFReader getReader(String lang) {
        String className;
        if (lang == null || lang.equals("")) {
            lang = LANGS[0];
        }
        if ((className = langToClassName.getProperty(lang)) == null || className.equals("")) {
            throw new NoReaderForLangException(lang);
        }
        try {
            return (RDFReader)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException e2) {
            if (className.equals(GRDDLREADER)) {
                throw new ConfigException("The GRDDL reader must be downloaded separately from Sourceforge, and included on the classpath.", e2);
            }
            throw new ConfigException("Reader not found on classpath", e2);
        }
        catch (Exception e3) {
            throw new JenaException(e3);
        }
    }

    public String setReaderClassName(String lang, String className) {
        return RDFReaderFImpl.setBaseReaderClassName(lang, className);
    }

    public static String setBaseReaderClassName(String lang, String className) {
        String oldClassName = langToClassName.getProperty(lang);
        langToClassName.setProperty(lang, className);
        return oldClassName;
    }

    static {
        langToClassName = new Properties();
        for (int i = 0; i < LANGS.length; ++i) {
            langToClassName.setProperty(LANGS[i], JenaRuntime.getSystemProperty(PROPNAMEBASE + LANGS[i], DEFAULTREADERS[i]));
        }
    }
}

