/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregateFactory;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;

public class AggAvg
implements AggregateFactory {
    private Expr expr;
    private static final NodeValue noValuesToAvg = NodeValue.nvZERO;

    public AggAvg(Expr var) {
        this.expr = var;
    }

    public Aggregator create() {
        return new AggAvgWorker();
    }

    class AccAvgVar
    implements Accumulator {
        private NodeValue total = AggAvg.access$100();
        private int count = 0;
        static final boolean DEBUG = false;

        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            try {
                NodeValue nv = AggAvg.this.expr.eval(binding, functionEnv);
                if (nv.isNumber()) {
                    ++this.count;
                    this.total = this.total == noValuesToAvg ? nv : XSDFuncOp.add(nv, this.total);
                }
            }
            catch (ExprEvalException exprEvalException) {
                // empty catch block
            }
        }

        public NodeValue getValue() {
            if (this.count == 0) {
                return noValuesToAvg;
            }
            NodeValue nvCount = NodeValue.makeInteger(this.count);
            return XSDFuncOp.divide(this.total, nvCount);
        }
    }

    class AggAvgWorker
    extends AggregatorBase {
        public String toString() {
            return "sum(" + ExprUtils.fmtSPARQL(AggAvg.this.expr) + ")";
        }

        public String toPrefixString() {
            return "(sum " + WriterExpr.asString(AggAvg.this.expr) + ")";
        }

        protected Accumulator createAccumulator() {
            return new AccAvgVar();
        }

        private final Expr getExpr() {
            return AggAvg.this.expr;
        }

        public boolean equalsAsExpr(Aggregator other) {
            if (!(other instanceof AggAvgWorker)) {
                return false;
            }
            AggAvgWorker agg = (AggAvgWorker)other;
            return agg.getExpr().equals(this.getExpr());
        }

        public Node getValueEmpty() {
            return NodeValue.toNode(noValuesToAvg);
        }
    }
}

