/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.NodeConst;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregateFactory;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;

public class AggCountVar
implements AggregateFactory {
    private Expr expr;

    public AggCountVar(Expr expr) {
        this.expr = expr;
    }

    public Aggregator create() {
        return new AggCountVarWorker();
    }

    private class AccCountVar
    implements Accumulator {
        private long count = 0L;

        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            try {
                NodeValue nv = AggCountVar.this.expr.eval(binding, functionEnv);
                ++this.count;
            }
            catch (ExprEvalException exprEvalException) {
                // empty catch block
            }
        }

        public NodeValue getValue() {
            return NodeValue.makeInteger(this.count);
        }
    }

    private class AggCountVarWorker
    extends AggregatorBase {
        public String toString() {
            return "count(" + AggCountVar.this.expr + ")";
        }

        public String toPrefixString() {
            return "(count " + AggCountVar.this.expr + ")";
        }

        protected Accumulator createAccumulator() {
            return new AccCountVar();
        }

        private final Expr getExpr() {
            return AggCountVar.this.expr;
        }

        public boolean equalsAsExpr(Aggregator other) {
            if (!(other instanceof AggCountVarWorker)) {
                return false;
            }
            AggCountVarWorker agg = (AggCountVarWorker)other;
            return agg.getExpr().equals(this.getExpr());
        }

        public Node getValueEmpty() {
            return NodeConst.nodeZero;
        }
    }
}

