/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.NodeConst;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregateFactory;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import java.util.HashSet;
import java.util.Set;

public class AggCountVarDistinct
implements AggregateFactory {
    private Expr expr;

    public AggCountVarDistinct(Expr expr) {
        this.expr = expr;
    }

    public Aggregator create() {
        return new AggCountVarDistinctWorker(this.expr);
    }

    class AccCountVarDistinct
    implements Accumulator {
        private Set<NodeValue> seen = new HashSet<NodeValue>();

        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            try {
                NodeValue nv = AggCountVarDistinct.this.expr.eval(binding, functionEnv);
                this.seen.add(nv);
            }
            catch (ExprEvalException exprEvalException) {
                // empty catch block
            }
        }

        public NodeValue getValue() {
            return NodeValue.makeInteger(this.seen.size());
        }
    }

    class AggCountVarDistinctWorker
    extends AggregatorBase {
        public AggCountVarDistinctWorker(Expr expr) {
        }

        public String toString() {
            return "count(distinct " + AggCountVarDistinct.this.expr + ")";
        }

        public String toPrefixString() {
            return "(count distinct " + AggCountVarDistinct.this.expr + ")";
        }

        protected Accumulator createAccumulator() {
            return new AccCountVarDistinct();
        }

        private final Expr getExpr() {
            return AggCountVarDistinct.this.expr;
        }

        public boolean equalsAsExpr(Aggregator other) {
            if (!(other instanceof AggCountVarDistinctWorker)) {
                return false;
            }
            AggCountVarDistinctWorker agg = (AggCountVarDistinctWorker)other;
            return agg.getExpr().equals(this.getExpr());
        }

        public Node getValueEmpty() {
            return NodeConst.nodeZero;
        }
    }
}

