/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.nodevalue;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDuration;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.ExprException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueVisitor;

public class NodeValueDuration
extends NodeValue {
    XSDDuration duration;

    public NodeValueDuration(XSDDuration dt) {
        this.duration = dt;
        if (dt.getDays() != 0 && dt.getMonths() != 0 && dt.getYears() != 0) {
            throw new ExprException("Illegal time: " + dt);
        }
        if (dt.getTimePart() == 0.0) {
            throw new ExprException("Illegal time: " + dt);
        }
    }

    public NodeValueDuration(XSDDuration dt, Node n) {
        super(n);
        this.duration = dt;
    }

    public boolean isDuration() {
        return true;
    }

    public XSDDuration getDuration() {
        return this.duration;
    }

    protected Node makeNode() {
        String lex = this.duration.toString();
        return Node.createLiteral(lex, null, XSDDatatype.XSDtime);
    }

    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

