/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.lang.Parser;
import com.hp.hpl.jena.sparql.lang.sparql_10.ParseException;
import com.hp.hpl.jena.sparql.lang.sparql_10.SPARQLParser10;
import com.hp.hpl.jena.sparql.lang.sparql_10.TokenMgrError;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.util.ALog;
import java.io.StringReader;

public class ParserSPARQL10
extends Parser {
    public Query parse(Query query, String queryString) {
        query.setSyntax(Syntax.syntaxSPARQL_10);
        Action action = new Action(){

            public void exec(SPARQLParser10 parser) throws Exception {
                parser.QueryUnit();
            }
        };
        ParserSPARQL10.perform(query, queryString, action);
        this.validateParsedQuery(query);
        return query;
    }

    public static Element parseElement(String string) {
        final Query query = new Query();
        Action action = new Action(){

            public void exec(SPARQLParser10 parser) throws Exception {
                Element el = parser.GroupGraphPattern();
                query.setQueryPattern(el);
            }
        };
        ParserSPARQL10.perform(query, string, action);
        return query.getQueryPattern();
    }

    public static Template parseTemplate(String string) {
        final Query query = new Query();
        Action action = new Action(){

            public void exec(SPARQLParser10 parser) throws Exception {
                Template t = parser.ConstructTemplate();
                query.setConstructTemplate(t);
            }
        };
        ParserSPARQL10.perform(query, string, action);
        return query.getConstructTemplate();
    }

    private static void perform(Query query, String string, Action action) {
        StringReader in = new StringReader(string);
        SPARQLParser10 parser = new SPARQLParser10(in);
        try {
            query.setStrict(true);
            parser.setQuery(query);
            action.exec(parser);
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser.token.endColumn;
            int line = parser.token.endLine;
            throw new QueryParseException(tErr.getMessage(), line, col);
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (JenaException ex) {
            throw new QueryException(ex.getMessage(), ex);
        }
        catch (Error err) {
            throw new QueryParseException(err.getMessage(), (Throwable)err, -1, -1);
        }
        catch (Throwable th) {
            ALog.warn(ParserSPARQL10.class, "Unexpected throwable: ", th);
            throw new QueryException(th.getMessage(), th);
        }
    }

    private static interface Action {
        public void exec(SPARQLParser10 var1) throws Exception;
    }
}

