/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.AlreadyExists;
import com.hp.hpl.jena.sparql.DoesNotExist;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.modify.GraphStoreAction;
import com.hp.hpl.jena.sparql.modify.GraphStoreUtils;
import com.hp.hpl.jena.sparql.modify.UpdateVisitor;
import com.hp.hpl.jena.sparql.modify.op.UpdateClear;
import com.hp.hpl.jena.sparql.modify.op.UpdateCreate;
import com.hp.hpl.jena.sparql.modify.op.UpdateDelete;
import com.hp.hpl.jena.sparql.modify.op.UpdateDeleteData;
import com.hp.hpl.jena.sparql.modify.op.UpdateDrop;
import com.hp.hpl.jena.sparql.modify.op.UpdateExt;
import com.hp.hpl.jena.sparql.modify.op.UpdateInsert;
import com.hp.hpl.jena.sparql.modify.op.UpdateInsertData;
import com.hp.hpl.jena.sparql.modify.op.UpdateLoad;
import com.hp.hpl.jena.sparql.modify.op.UpdateModify;
import com.hp.hpl.jena.sparql.modify.op.UpdateModifyBase;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.util.FileManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateProcessorVisitor
implements UpdateVisitor {
    private GraphStore graphStore;
    private Binding binding;

    public UpdateProcessorVisitor(GraphStore graphStore, Binding initialBinding) {
        this.graphStore = graphStore;
        this.binding = initialBinding;
    }

    @Override
    public void visit(final UpdateInsertData insertData) {
        GraphStoreUtils.action(this.graphStore, insertData.getGraphNames(), new GraphStoreAction(){

            public void exec(Graph graph) {
                graph.getBulkUpdateHandler().add(insertData.getData());
            }
        });
    }

    @Override
    public void visit(final UpdateDeleteData deleteData) {
        GraphStoreUtils.action(this.graphStore, deleteData.getGraphNames(), new GraphStoreAction(){

            public void exec(Graph graph) {
                graph.getBulkUpdateHandler().delete(deleteData.getData());
            }
        });
    }

    @Override
    public void visit(UpdateModify modify) {
        this.visitModify(modify);
    }

    @Override
    public void visit(UpdateDelete delete) {
        this.visitModify(delete);
    }

    @Override
    public void visit(UpdateInsert insert) {
        this.visitModify(insert);
    }

    private void visitModify(final UpdateModifyBase modify) {
        final List<Binding> bindings = this.evalBindings(modify.getElement());
        GraphStoreUtils.action(this.graphStore, modify.getGraphNames(), new GraphStoreAction(){

            public void exec(Graph graph) {
                UpdateProcessorVisitor.this.execDeletes(modify, graph, bindings);
            }
        });
        GraphStoreUtils.action(this.graphStore, modify.getGraphNames(), new GraphStoreAction(){

            public void exec(Graph graph) {
                UpdateProcessorVisitor.this.execInserts(modify, graph, bindings);
            }
        });
    }

    private List<Binding> evalBindings(Element pattern) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        if (pattern != null) {
            Plan plan = QueryExecutionFactory.createPlan(pattern, (DatasetGraph)this.graphStore, this.binding);
            QueryIterator qIter = plan.iterator();
            while (qIter.hasNext()) {
                Binding b = qIter.nextBinding();
                bindings.add(b);
            }
            qIter.close();
        } else {
            bindings.add(BindingRoot.create());
        }
        return bindings;
    }

    private void execDeletes(UpdateModifyBase modify, Graph graph, List<Binding> bindings) {
        if (modify.getDeletes() != null) {
            QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(bindings.iterator());
            Collection<Triple> acc = UpdateProcessorVisitor.subst(modify.getDeletes(), qIter);
            graph.getBulkUpdateHandler().delete(acc.iterator());
        }
    }

    private void execInserts(UpdateModifyBase modify, Graph graph, List<Binding> bindings) {
        if (modify.getInserts() != null) {
            QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(bindings.iterator());
            Collection<Triple> acc = UpdateProcessorVisitor.subst(modify.getInserts(), qIter);
            graph.getBulkUpdateHandler().add(acc.iterator());
        }
    }

    @Override
    public void visit(UpdateClear clear) {
        GraphStoreUtils.action(this.graphStore, clear.getGraphName(), new GraphStoreAction(){

            public void exec(Graph graph) {
                graph.getBulkUpdateHandler().removeAll();
            }
        });
    }

    @Override
    public void visit(final UpdateLoad load) {
        GraphStoreUtils.action(this.graphStore, load.getGraphName(), new GraphStoreAction(){

            public void exec(Graph graph) {
                Model model = ModelFactory.createModelForGraph(graph);
                for (String s : load.getLoadIRIs()) {
                    FileManager.get().readModel(model, s);
                }
            }
        });
    }

    @Override
    public void visit(UpdateDrop drop) {
        Node n = drop.getIRI();
        if (!this.graphStore.containsGraph(n)) {
            if (drop.isSilent()) {
                return;
            }
            throw new DoesNotExist("Named graph: " + n);
        }
        this.graphStore.removeGraph(n);
    }

    @Override
    public void visit(UpdateCreate create) {
        Node n = create.getIRI();
        if (this.graphStore.containsGraph(n)) {
            if (create.isSilent()) {
                return;
            }
            throw new AlreadyExists("Named graph: " + n);
        }
        Graph graph = GraphFactory.createDefaultGraph();
        this.graphStore.addGraph(n, graph);
    }

    @Override
    public void visit(UpdateExt updateExt) {
        updateExt.update();
    }

    protected static Collection<Triple> subst(Template template, QueryIterator qIter) {
        HashSet<Triple> acc = new HashSet<Triple>();
        while (qIter.hasNext()) {
            HashMap<Node, Node> bNodeMap = new HashMap<Node, Node>();
            Binding b = qIter.nextBinding();
            template.subst(acc, bNodeMap, b);
        }
        Iterator iter = acc.iterator();
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            if (UpdateProcessorVisitor.isGroundTriple(triple)) continue;
            ALog.warn(UpdateProcessorVisitor.class, "Unbound triple: " + FmtUtils.stringForTriple(triple));
            iter.remove();
        }
        return acc;
    }

    private static boolean isGroundTriple(Triple triple) {
        return UpdateProcessorVisitor.isGroundNode(triple.getSubject()) && UpdateProcessorVisitor.isGroundNode(triple.getPredicate()) && UpdateProcessorVisitor.isGroundNode(triple.getObject());
    }

    private static boolean isGroundNode(Node node) {
        return node.isConcrete();
    }
}

