/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

public class DateTimeStruct {
    public boolean xsdDateTime;
    public String neg = null;
    public String year = null;
    public String month = null;
    public String day = null;
    public String hour = null;
    public String minute = null;
    public String second = null;
    public String timezone = null;

    private DateTimeStruct() {
    }

    public String toString() {
        String ySep = "-";
        String tSep = ":";
        String x = this.year + ySep + this.month + ySep + this.day;
        if (this.xsdDateTime) {
            x = x + "T" + this.hour + tSep + this.minute + tSep + this.second;
        }
        if (this.neg != null) {
            x = this.neg + x;
        }
        if (this.timezone != null) {
            x = x + this.timezone;
        }
        return x;
    }

    public static DateTimeStruct parseDateTime(String str2) {
        return DateTimeStruct._parseYMD(str2, true, true, true);
    }

    public static DateTimeStruct parseDate(String str2) {
        return DateTimeStruct._parseYMD(str2, true, true, false);
    }

    public static DateTimeStruct parseGYear(String str2) {
        return DateTimeStruct._parseYMD(str2, false, false, false);
    }

    public static DateTimeStruct parseGYearMonth(String str2) {
        return DateTimeStruct._parseYMD(str2, true, false, false);
    }

    public static DateTimeStruct parseGMonth(String str2) {
        return DateTimeStruct._parseMD(str2, true, false);
    }

    public static DateTimeStruct parseGMonthDay(String str2) {
        return DateTimeStruct._parseMD(str2, true, true);
    }

    public static DateTimeStruct parseGDay(String str2) {
        return DateTimeStruct._parseMD(str2, false, true);
    }

    private static DateTimeStruct _parseYMD(String str2, boolean month, boolean day, boolean includeTime) {
        DateTimeStruct struct = new DateTimeStruct();
        int idx = 0;
        boolean negYear = false;
        if (str2.charAt(idx) == '-') {
            struct.neg = "-";
            ++idx;
        }
        struct.year = DateTimeStruct.getDigits(4, str2, idx);
        idx += 4;
        if (month) {
            DateTimeStruct.check(str2, idx, '-');
            struct.month = DateTimeStruct.getDigits(2, str2, ++idx);
            idx += 2;
        }
        if (day) {
            DateTimeStruct.check(str2, idx, '-');
            struct.day = DateTimeStruct.getDigits(2, str2, ++idx);
            idx += 2;
        }
        if (includeTime) {
            struct.xsdDateTime = true;
            DateTimeStruct.check(str2, idx, 'T');
            struct.hour = DateTimeStruct.getDigits(2, str2, ++idx);
            DateTimeStruct.check(str2, idx += 2, ':');
            struct.minute = DateTimeStruct.getDigits(2, str2, ++idx);
            DateTimeStruct.check(str2, idx += 2, ':');
            struct.second = DateTimeStruct.getDigits(2, str2, ++idx);
            if ((idx += 2) < str2.length() && str2.charAt(idx) == '.') {
                char ch;
                int idx2;
                for (idx2 = ++idx; idx2 < str2.length() && Character.isDigit(ch = str2.charAt(idx2)); ++idx2) {
                }
                if (idx == idx2) {
                    throw new DateTimeParseException();
                }
                struct.second = struct.second + '.' + str2.substring(idx, idx2);
                idx = idx2;
            }
        }
        if ((idx = DateTimeStruct._parseTimezone(struct, str2, idx)) != str2.length()) {
            throw new DateTimeParseException();
        }
        return struct;
    }

    private static DateTimeStruct _parseMD(String str2, boolean month, boolean day) {
        DateTimeStruct struct = new DateTimeStruct();
        int idx = 0;
        DateTimeStruct.check(str2, idx, '-');
        DateTimeStruct.check(str2, ++idx, '-');
        ++idx;
        if (month) {
            struct.month = DateTimeStruct.getDigits(2, str2, idx);
            idx += 2;
        }
        if (day) {
            DateTimeStruct.check(str2, idx, '-');
            struct.day = DateTimeStruct.getDigits(2, str2, ++idx);
            idx += 2;
        }
        if ((idx = DateTimeStruct._parseTimezone(struct, str2, idx)) != str2.length()) {
            throw new DateTimeParseException();
        }
        return struct;
    }

    private static int _parseTimezone(DateTimeStruct struct, String str2, int idx) {
        if (idx >= str2.length()) {
            struct.timezone = null;
            return idx;
        }
        if (str2.charAt(idx) == 'Z') {
            struct.timezone = "Z";
            ++idx;
        } else {
            StringBuilder sb = new StringBuilder();
            if (str2.charAt(idx) == '+') {
                sb.append('+');
            } else if (str2.charAt(idx) == '-') {
                sb.append('-');
            } else {
                throw new DateTimeParseException();
            }
            sb.append(DateTimeStruct.getDigits(2, str2, ++idx));
            DateTimeStruct.check(str2, idx += 2, ':');
            sb.append(':');
            sb.append(DateTimeStruct.getDigits(2, str2, ++idx));
            idx += 2;
            struct.timezone = sb.toString();
        }
        return idx;
    }

    private static String _parse(DateTimeStruct struct, String str2, int idx, int len) {
        String substring2 = null;
        if (str2.length() <= idx) {
            throw new DateTimeParseException();
        }
        if (str2.charAt(idx) == '-') {
            substring2 = "-";
            ++idx;
        } else {
            substring2 = DateTimeStruct.getDigits(len, str2, idx);
            idx += len;
        }
        return substring2;
    }

    private static String parseYear(DateTimeStruct struct, String str2, int idx) {
        return DateTimeStruct._parse(struct, str2, idx, 4);
    }

    private static DateTimeStruct _parse(String str2, boolean includeTime) {
        DateTimeStruct struct = new DateTimeStruct();
        int idx = 0;
        if (str2.startsWith("-")) {
            struct.neg = "-";
            idx = 1;
        }
        struct.year = DateTimeStruct.getDigits(4, str2, idx);
        DateTimeStruct.check(str2, idx += 4, '-');
        struct.month = DateTimeStruct.getDigits(2, str2, ++idx);
        DateTimeStruct.check(str2, idx += 2, '-');
        struct.day = DateTimeStruct.getDigits(2, str2, ++idx);
        idx += 2;
        struct.xsdDateTime = false;
        if (includeTime) {
            struct.xsdDateTime = true;
            DateTimeStruct.check(str2, idx, 'T');
            struct.hour = DateTimeStruct.getDigits(2, str2, ++idx);
            DateTimeStruct.check(str2, idx += 2, ':');
            struct.minute = DateTimeStruct.getDigits(2, str2, ++idx);
            DateTimeStruct.check(str2, idx += 2, ':');
            struct.second = DateTimeStruct.getDigits(2, str2, ++idx);
            if ((idx += 2) < str2.length() && str2.charAt(idx) == '.') {
                char ch;
                int idx2;
                for (idx2 = ++idx; idx2 < str2.length() && Character.isDigit(ch = str2.charAt(idx2)); ++idx2) {
                }
                if (idx == idx2) {
                    throw new DateTimeParseException();
                }
                struct.second = struct.second + '.' + str2.substring(idx, idx2);
                idx = idx2;
            }
        } else {
            struct.hour = null;
            struct.minute = null;
            struct.second = null;
        }
        if (idx < str2.length()) {
            if (str2.charAt(idx) == 'Z') {
                struct.timezone = "Z";
                ++idx;
            } else {
                StringBuilder sb = new StringBuilder();
                if (str2.charAt(idx) == '+') {
                    sb.append('+');
                } else if (str2.charAt(idx) == '-') {
                    sb.append('-');
                } else {
                    throw new DateTimeParseException();
                }
                sb.append(DateTimeStruct.getDigits(2, str2, ++idx));
                DateTimeStruct.check(str2, idx += 2, ':');
                sb.append(':');
                sb.append(DateTimeStruct.getDigits(2, str2, ++idx));
                idx += 2;
                struct.timezone = sb.toString();
            }
        }
        if (idx != str2.length()) {
            throw new DateTimeParseException();
        }
        return struct;
    }

    private static String getDigits(int num, String string, int start) {
        for (int i = start; i < start + num; ++i) {
            char ch = string.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            throw new DateTimeParseException();
        }
        return string.substring(start, start + num);
    }

    private static void check(String string, int idx, char x) {
        if (string.length() <= idx || string.charAt(idx) != x) {
            throw new DateTimeParseException();
        }
    }

    public static class DateTimeParseException
    extends RuntimeException {
    }
}

