/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.tuple;

import com.hp.hpl.jena.util.tuple.TupleItem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleSet
implements Iterator<List<TupleItem>> {
    BufferedReader in;
    public String line = null;
    public int lineNumber = 0;
    static final char COMMENTCHAR = '#';
    List<TupleItem> current = null;
    boolean finished = false;
    protected static Logger logger = LoggerFactory.getLogger(TupleSet.class);

    public TupleSet(Reader r) {
        this.in = !(r instanceof BufferedReader) ? new BufferedReader(r) : (BufferedReader)r;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.current == null) {
            this.current = this.tuple();
        }
        return this.current != null;
    }

    @Override
    public List<TupleItem> next() {
        if (this.hasNext()) {
            List<TupleItem> x = this.current;
            this.current = null;
            return x;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("TupleSet.remove");
    }

    private List<TupleItem> tuple() {
        try {
            ++this.lineNumber;
            this.line = this.in.readLine();
        }
        catch (IOException e2) {
            // empty catch block
        }
        if (this.line == null) {
            this.finished = true;
            return null;
        }
        ArrayList<TupleItem> tuple = new ArrayList<TupleItem>();
        int i = 0;
        int j = 0;
        boolean errorFound = false;
        block9: while ((i = this.skipwhitespace(this.line, j)) >= 0) {
            int iStart = -2;
            int jStart = -2;
            int iFinish = -2;
            int jFinish = -2;
            int dtStart = -2;
            int dtFinish = -2;
            int type = 2;
            switch (this.line.charAt(i)) {
                case '#': {
                    break block9;
                }
                case '<': {
                    type = 0;
                    iStart = i;
                    jStart = i + 1;
                    int newPosn = this.parseURI(i, this.line);
                    if (newPosn < 0) {
                        errorFound = true;
                        break block9;
                    }
                    j = newPosn;
                    iFinish = j + 1;
                    jFinish = j;
                    break;
                }
                case '\"': {
                    type = 1;
                    iStart = i;
                    jStart = i + 1;
                    boolean inEscape = false;
                    for (j = i + 1; j < this.line.length(); ++j) {
                        char ch = this.line.charAt(j);
                        if (inEscape) {
                            inEscape = false;
                            continue;
                        }
                        if (ch == '\"') break;
                        if (ch == '\\') {
                            inEscape = true;
                        }
                        if (ch != '\n' && ch != '\r') continue;
                        errorFound = true;
                        break block9;
                    }
                    if (j == this.line.length()) {
                        errorFound = true;
                        break block9;
                    }
                    iFinish = j + 1;
                    jFinish = j;
                    if (j >= this.line.length() - 3 || this.line.charAt(j + 1) != '^' || this.line.charAt(j + 2) != '^' || this.line.charAt(j + 3) != '<') break;
                    dtFinish = this.parseURI(j + 3, this.line);
                    dtStart = j + 4;
                    if (dtFinish < 0) {
                        errorFound = true;
                        break block9;
                    }
                    j = dtFinish + 1;
                    break;
                }
                case '_': {
                    char ch;
                    type = 4;
                    iStart = i;
                    for (j = i + 1; j < this.line.length() && (ch = this.line.charAt(j)) != ' ' && ch != '\t' && ch != '.'; ++j) {
                        if (Character.isLetterOrDigit(ch) || ch == '_' || ch == ':') continue;
                        errorFound = true;
                        break block9;
                    }
                    iFinish = j;
                    jStart = iStart;
                    jFinish = iFinish;
                    break;
                }
                case '\n': 
                case '\r': 
                case '.': {
                    return tuple;
                }
                default: {
                    char ch;
                    type = 3;
                    iStart = i;
                    jStart = i;
                    for (j = i + 1; j < this.line.length() && (ch = this.line.charAt(j)) != ' ' && ch != '\t' && ch != '.'; ++j) {
                    }
                    if (j == this.line.length() + 1) {
                        errorFound = true;
                        break block9;
                    }
                    iFinish = j;
                    jFinish = j;
                }
            }
            String item = this.line.substring(jStart, jFinish);
            String literal = this.line.substring(iStart, iFinish);
            String dt = null;
            if (dtStart > 0) {
                dt = this.line.substring(dtStart, dtFinish);
            }
            tuple.add(new TupleItem(item, literal, type, dt));
            ++j;
        }
        if (errorFound) {
            int k;
            logger.error("Error in TupleSet.tuple: " + this.line);
            String s = "";
            for (k = 0; k < i; ++k) {
                s = s + " ";
            }
            s = s + "^";
            while (k < j - 1) {
                s = s + " ";
                ++k;
            }
            s = s + "^";
            logger.error(s);
            return null;
        }
        if (tuple.size() == 0) {
            return this.tuple();
        }
        return tuple;
    }

    private int skipwhitespace(String s, int i) {
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch != ' ' && ch != '\t') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int parseURI(int i, String line) {
        char ch;
        int j;
        for (j = i + 1; j < line.length() && (ch = line.charAt(j)) != '>'; ++j) {
            if (ch != '\n' && ch != '\r') continue;
            return -1;
        }
        if (j == line.length()) {
            return -2;
        }
        return j;
    }
}

