/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement.optimal;

import org.beetl.core.Context;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.om.AABuilder;
import org.beetl.core.om.AttributeAccess;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.VarAttribute;
import org.beetl.core.statement.VarRef;

public class VarRefOptimal
extends VarRef {
    public VarAttribute attribute;
    public int varIndex;

    public VarRefOptimal(VarAttribute attribute, GrammarToken token, GrammarToken firstToken) {
        super(null, false, null, token, firstToken);
        this.attribute = attribute;
    }

    @Override
    public Object evaluate(Context ctx) {
        Object value = this.getValue(ctx);
        if (value == null) {
            BeetlException be = new BeetlException("NULL", "\u7a7a\u6307\u9488");
            be.pushToken(this.token);
            throw be;
        }
        try {
            value = this.attribute.evaluate(ctx, value);
        }
        catch (BeetlException ex) {
            ex.pushToken(this.attribute.token);
            throw ex;
        }
        catch (RuntimeException ex) {
            BeetlException be = new BeetlException("ATTRIBUTE_INVALID", "\u5c5e\u6027\u8bbf\u95ee\u51fa\u9519", ex);
            be.pushToken(this.attribute.token);
            throw be;
        }
        return value;
    }

    private Object getValue(Context ctx) {
        Object value = ctx.vars[this.varIndex];
        if (value == Context.NOT_EXIST_OBJECT) {
            if (ctx.globalVar != null && ctx.globalVar.containsKey("_root")) {
                Object root = ctx.getGlobal("_root");
                String attr = this.firstToken.text;
                if (root == null) {
                    BeetlException be = new BeetlException("NULL", "_root\u4e3a\u7a7a\u6307\u9488\uff0c\u65e0" + this.token.text + "\u503c");
                    be.pushToken(this.firstToken);
                    throw be;
                }
                AttributeAccess aa = AABuilder.buildFiledAccessor(root.getClass());
                try {
                    value = aa.value(root, attr);
                }
                catch (RuntimeException e) {
                    BeetlException ex = new BeetlException("ATTRIBUTE_INVALID", "_root " + root.getClass() + " \u5c5e\u6027\u8bbf\u95ee\u9519\u8bef");
                    ex.pushToken(this.firstToken);
                    throw ex;
                }
                return value;
            }
            BeetlException ex = new BeetlException("VAR_NOT_DEFINED");
            ex.pushToken(this.firstToken);
            throw ex;
        }
        return value;
    }

    @Override
    public void setVarIndex(int index) {
        this.varIndex = index;
    }

    @Override
    public int getVarIndex() {
        return this.varIndex;
    }
}

