/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.text;

import java.util.ArrayList;
import java.util.List;
import org.beetl.core.text.CRFragment;
import org.beetl.core.text.Fragment;
import org.beetl.core.text.FragmentStatus;
import org.beetl.core.text.PlaceHolderFragment;
import org.beetl.core.text.ScriptFragment;
import org.beetl.core.text.TextFragment;

public class SourceFragement {
    List<Fragment> list = new ArrayList<Fragment>();
    int startLineIndex = 0;
    int startLine = 0;

    public void add(Fragment fr) {
        this.list.add(fr);
        if (fr instanceof CRFragment) {
            this.trimSpace();
            this.moveNext(fr);
            return;
        }
        if (fr.endLine != this.startLine) {
            this.trimSpace();
            this.moveNext(fr);
            return;
        }
    }

    protected void moveNext(Fragment fr) {
        this.startLineIndex = this.list.size();
        this.startLine = fr instanceof CRFragment ? fr.endLine + 1 : fr.endLine;
    }

    public void merge() {
        this.check();
        block0: for (int i = 0; i < this.list.size(); ++i) {
            Fragment fr = this.list.get(i);
            if (fr.getStatus() == FragmentStatus.del || !(fr instanceof TextFragment)) continue;
            TextFragment text = (TextFragment)fr;
            for (int z = i + 1; z < this.list.size(); ++z) {
                Fragment nextFr = this.list.get(z);
                if (nextFr instanceof ScriptFragment || nextFr instanceof PlaceHolderFragment) {
                    i = z;
                    continue block0;
                }
                nextFr.setStatus(FragmentStatus.del);
                text.appendTextFragment(nextFr);
            }
        }
    }

    private void check() {
        if (this.startLineIndex != this.list.size()) {
            this.trimSpace();
        }
    }

    protected void trimSpace() {
        boolean hasScript = false;
        for (int i = this.startLineIndex; i < this.list.size(); ++i) {
            Fragment fr = this.list.get(i);
            if (fr instanceof CRFragment) continue;
            if (fr instanceof PlaceHolderFragment) {
                return;
            }
            if (fr instanceof TextFragment) {
                TextFragment textFragment = (TextFragment)fr;
                if (textFragment.onlySpace()) continue;
                return;
            }
            hasScript = true;
        }
        if (!hasScript) {
            return;
        }
        Fragment lastScript = null;
        for (int i = this.startLineIndex; i < this.list.size(); ++i) {
            Fragment fr = this.list.get(i);
            if (fr instanceof TextFragment) {
                fr.setStatus(FragmentStatus.del);
                continue;
            }
            if (fr instanceof CRFragment) {
                if (lastScript == null) continue;
                fr.setStatus(FragmentStatus.del);
                ((ScriptFragment)lastScript).appendCr();
                continue;
            }
            lastScript = fr;
        }
    }
}

