/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.text.AttributeNameConvert;
import org.beetl.core.text.DefaultAttributeNameConvert;
import org.beetl.core.text.Fragment;
import org.beetl.core.text.FragmentStatus;
import org.beetl.core.text.HtmlTagConfig;
import org.beetl.core.text.PlaceHolderDelimeter;
import org.beetl.core.text.ScriptDelimeter;
import org.beetl.core.text.Source;
import org.beetl.core.text.SourceFragement;
import org.beetl.core.text.TextFragment;

public class TextParser {
    Map<Integer, String> textVars = new HashMap<Integer, String>();
    int textNameSuffix = 0;
    PlaceHolderDelimeter pd;
    ScriptDelimeter sd;
    Source source = null;
    StringBuilder script = new StringBuilder(64);
    public static final char cr1 = '\n';
    public static final String systemCrStr = System.getProperty("line.separator");
    SourceFragement sourceFragement = new SourceFragement();
    HtmlTagConfig htmlTagConfig = null;
    String textCr = null;
    AttributeNameConvert attributeNameConvert;

    public TextParser(GroupTemplate groupTemplate, Configuration.DelimeterHolder pdConfig, Configuration.DelimeterHolder sdConfig) {
        if (groupTemplate == null) {
            this.attributeNameConvert = new DefaultAttributeNameConvert();
        }
        this.pd = pdConfig.createPhd();
        this.sd = sdConfig.createSd();
    }

    public TextParser(GroupTemplate groupTemplate, Configuration.DelimeterHolder pdConfig, Configuration.DelimeterHolder sdConfig, Configuration.HtmlTagHolder tagConfig) {
        this(groupTemplate, pdConfig, sdConfig);
        this.htmlTagConfig = tagConfig.create();
    }

    public TextParser(Configuration.DelimeterHolder pdConfig, Configuration.DelimeterHolder sdConfig, Configuration.HtmlTagHolder tagConfig) {
        this(null, pdConfig, sdConfig);
        this.htmlTagConfig = tagConfig.create();
    }

    public void doParse(Reader orginal) throws IOException {
        this.scan1(orginal);
        this.sourceFragement.merge();
        for (Fragment f : this.sourceFragement.list) {
            if (f.getStatus() == FragmentStatus.del) continue;
            this.script.append((CharSequence)f.getScript());
        }
        String cr = this.source.findCr();
        this.textCr = cr != null ? cr : systemCrStr;
    }

    protected void scan1(Reader orginal) throws IOException {
        StringBuilder temp = new StringBuilder();
        int bufSzie = 1024;
        char[] cs = new char[bufSzie];
        int len = -1;
        while ((len = orginal.read(cs)) != -1) {
            temp.append(cs, 0, len);
        }
        cs = temp.toString().toCharArray();
        this.source = new Source(cs);
        this.source.init(this, this.pd, this.sd, this.htmlTagConfig);
        Fragment test = new TextFragment(this.source);
        Fragment next = null;
        while (true) {
            next = ((Fragment)test).consumeAndReturnNext();
            this.sourceFragement.add(test);
            if (next == null) break;
            test = next;
        }
    }

    public StringBuilder getScript() {
        return this.script;
    }

    public Map<Integer, String> getTextVars() {
        return this.textVars;
    }

    public Integer getRandomeTextVarName() {
        return this.textNameSuffix++;
    }

    public void setTextVars(Map<Integer, String> textVars) {
        this.textVars = textVars;
    }

    public String getTextCr() {
        return this.textCr;
    }

    public static void main(String[] args) throws IOException {
        Configuration.DelimeterHolder pd = new Configuration.DelimeterHolder("${".toCharArray(), "}".toCharArray(), "#{".toCharArray(), "}".toCharArray());
        Configuration.DelimeterHolder sd = new Configuration.DelimeterHolder("@".toCharArray(), null, "<%".toCharArray(), "%>".toCharArray());
        Configuration.HtmlTagHolder htmlConfig = new Configuration.HtmlTagHolder();
        String text = "\\@ a";
        StringReader str = new StringReader(text);
        TextParser textParser = new TextParser(null, pd, sd, htmlConfig);
        textParser.doParse(str);
        System.out.println(textParser.getTextVars());
        String line = null;
        BufferedReader reader = new BufferedReader(new StringReader(textParser.getScript().toString()));
        System.out.println("==============================");
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
        }
    }
}

