/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.ow2.asm;

import java.lang.annotation.ElementType;
import java.util.ArrayDeque;
import java.util.Deque;
import org.beetl.ow2.asm.Type;

public class AsmContext {
    private static final ThreadLocal<AsmContext> current = new ThreadLocal();
    private static final ThreadLocal<Integer> line = new ThreadLocal();
    private String name;
    private ElementType type;
    private AsmContext parent;
    private Integer lineNo;

    AsmContext(String name, ElementType type) {
        this.name = name;
        this.type = type;
    }

    public String name() {
        return this.name;
    }

    public ElementType type() {
        return this.type;
    }

    public Integer lineNo() {
        return this.lineNo;
    }

    public String className() {
        AsmContext ctx = this;
        while (null != ctx) {
            if (ElementType.TYPE == ctx.type) {
                return ctx.name;
            }
            ctx = ctx.parent;
        }
        throw new RuntimeException("Cannot reach type context");
    }

    public String toString() {
        ArrayDeque<AsmContext> deque = new ArrayDeque<AsmContext>();
        AsmContext ctx = this;
        while (null != ctx) {
            deque.push(ctx);
            ctx = ctx.parent;
        }
        StringBuilder sb = new StringBuilder();
        AsmContext.print(sb, deque);
        return sb.toString();
    }

    private static void print(StringBuilder sb, Deque<AsmContext> stack) {
        AsmContext ctx = stack.pop();
        sb.append(ctx.name);
        while (!stack.isEmpty()) {
            sb.append("::");
            ctx = stack.pop();
            sb.append(ctx.name);
            if (ElementType.METHOD != ctx.type) continue;
            sb.append("()");
        }
    }

    public static void line(int lineNo) {
        line.set(lineNo);
    }

    public static int line() {
        return line.get();
    }

    public static void enterClass(String className) {
        AsmContext parent = AsmContext.current();
        AsmContext context = new AsmContext(Type.getObjectType(className).getClassName(), ElementType.TYPE);
        current.set(context);
        if (null != parent) {
            context.parent = parent;
        }
    }

    public static void enterField(String fieldName) {
        AsmContext.enterSubContext(fieldName, ElementType.FIELD);
    }

    public static void enterMethod(String methodName) {
        AsmContext.enterSubContext(methodName, ElementType.METHOD);
    }

    public static void enterParemter(String paramName) {
        AsmContext.enterSubContext(paramName, ElementType.PARAMETER);
    }

    public static void enterAnnotation(String annoName) {
        AsmContext.enterSubContext(annoName, ElementType.ANNOTATION_TYPE);
    }

    public static void exit() {
        AsmContext context = AsmContext.current();
        if (null != context) {
            AsmContext parent = context.parent;
            if (null != parent) {
                context.parent = null;
                current.set(parent);
            } else {
                current.remove();
            }
        }
        line.remove();
    }

    private static AsmContext current() {
        return current.get();
    }

    public static AsmContext reset() {
        AsmContext context = AsmContext.current();
        if (null != context) {
            context.lineNo = line.get();
        }
        current.remove();
        line.remove();
        return context;
    }

    private static void enterSubContext(String name, ElementType type) {
        AsmContext parent = AsmContext.current();
        if (null == parent) {
            throw new IllegalStateException("parent context not found");
        }
        AsmContext context = new AsmContext(name, type);
        context.parent = parent;
        current.set(context);
    }
}

