/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.impl.cache;

import org.beetl.android.util.Log;
import org.beetl.core.config.BeetlConfig;
import org.beetl.core.fun.ObjectUtil;
import org.beetl.core.impl.cache.DefaultBeetlCache;
import org.beetl.core.runtime.IBeetlCache;
import org.jetbrains.annotations.NotNull;

public class DefaultBeetlCacheFactory {
    private static final boolean DEBUG = BeetlConfig.DEBUG;
    private static final String TAG = "ProgramCacheFactory";
    public static String DEFAULT_CACHE_CLASS_NAME = "org.beetl.core.impl.cache.DefaultBeetlCache";

    private DefaultBeetlCacheFactory() {
    }

    @NotNull
    public static IBeetlCache defaultCache() {
        return DefaultBeetlCacheFactory.loadCache(DEFAULT_CACHE_CLASS_NAME);
    }

    @NotNull
    public static IBeetlCache loadCache(String className) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = DefaultBeetlCacheFactory.class.getClassLoader();
        }
        try {
            return (IBeetlCache)ObjectUtil.instance(className, loader);
        }
        catch (Exception ex) {
            if (DEBUG) {
                Log.d(TAG, "#loadCache fail. className=" + className + " classLoader=" + loader + " ex=\n" + ex.toString());
            }
            return new DefaultBeetlCache();
        }
    }
}

