/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.beetl.core.Context;
import org.beetl.core.NativeSecurityManager;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.fun.ObjectUtil;
import org.beetl.core.misc.BeetlUtil;
import org.beetl.core.om.ObjectMethodMatchConf;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.nat.ClassNode;
import org.beetl.core.statement.nat.InstanceNode;
import org.beetl.core.statement.nat.NativeArrayNode;
import org.beetl.core.statement.nat.NativeAttributeNode;
import org.beetl.core.statement.nat.NativeMethodNode;
import org.beetl.core.statement.nat.NativeNode;

public class NativeCallExpression
extends Expression {
    protected InstanceNode insNode;
    protected ClassNode clsNode;
    protected NativeNode[] chain;

    public NativeCallExpression(InstanceNode insNode, NativeNode[] chain, GrammarToken token) {
        super(token);
        this.insNode = insNode;
        this.chain = chain;
    }

    public NativeCallExpression(ClassNode clsNode, NativeNode[] chain, GrammarToken token) {
        super(token);
        this.clsNode = clsNode;
        this.chain = chain;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object evaluate(Context ctx) {
        Class<?> targetCls = null;
        Object targetObj = null;
        Object var4_4 = null;
        if (this.insNode != null) {
            targetObj = this.insNode.ref.evaluate(ctx);
            if (targetObj != null) {
                targetCls = targetObj.getClass();
            }
            InstanceNode instanceNode = this.insNode;
        } else {
            targetCls = ctx.gt.loadClassBySimpleName(this.clsNode.clazz);
            if (targetCls == null) {
                throw new BeetlException("NATIVE_CALL_EXCEPTION", "\u8be5\u7c7b\u4e0d\u5b58\u5728").pushToken(GrammarToken.createToken(this.clsNode.clazz, this.token.line));
            }
            ClassNode classNode = this.clsNode;
        }
        for (NativeNode node : this.chain) {
            void var4_8;
            if (node instanceof NativeAttributeNode) {
                String attr = ((NativeAttributeNode)node).attribute;
                try {
                    this.checkNull(targetCls, (NativeNode)var4_8);
                    Field f = targetCls.getField(attr);
                    if (!Modifier.isStatic(f.getModifiers())) {
                        this.checkNull(targetObj, (NativeNode)var4_8);
                    }
                    targetObj = f.get(targetObj);
                    targetCls = f.getType();
                }
                catch (SecurityException e) {
                    throw new BeetlException("NATIVE_CALL_EXCEPTION", "\u4e0d\u80fd\u8c03\u7528\u5c5e\u6027", e).pushToken(GrammarToken.createToken(attr, this.token.line));
                }
                catch (NoSuchFieldException e) {
                    throw new BeetlException("NATIVE_CALL_EXCEPTION", "\u65e0\u6b64\u5c5e\u6027", e).pushToken(GrammarToken.createToken(attr, this.token.line));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new BeetlException("NATIVE_CALL_EXCEPTION", "\u8bbf\u95ee\u5c5e\u6027\u51fa\u9519", e).pushToken(GrammarToken.createToken(attr, this.token.line));
                }
            }
            if (node instanceof NativeArrayNode) {
                this.checkNull(targetCls, (NativeNode)var4_8);
                if (!targetCls.isArray()) {
                    throw new BeetlException("ARRAY_TYPE_ERROR").pushToken(GrammarToken.createToken("[]", this.token.line));
                }
                Expression exp = ((NativeArrayNode)node).exp;
                Object value = exp.evaluate(ctx);
                if (!(value instanceof Number)) throw new BeetlException("ARRAY_INDEX_ERROR", "\u6570\u7ec4\u6307\u9488\u5fc5\u987b\u662fNumber\u7c7b\u578b").pushToken(GrammarToken.createToken("[]", this.token.line));
                int index = ((Number)value).intValue();
                targetCls = (targetObj = ((Object[])targetObj)[index]) == null ? null : targetObj.getClass();
            } else if (node instanceof NativeMethodNode) {
                NativeMethodNode methodNode = (NativeMethodNode)node;
                String method = methodNode.method;
                Expression[] expList = methodNode.params;
                this.checkPermit(ctx, targetCls, targetObj, method);
                Object[] args = expList.length == 0 ? ObjectUtil.EMPTY_OBJECT_ARRAY : new Object[expList.length];
                Class[] parameterType = new Class[args.length];
                for (int i = 0; i < expList.length; ++i) {
                    args[i] = expList[i].evaluate(ctx);
                    parameterType[i] = args[i] == null ? null : args[i].getClass();
                }
                this.checkNull(targetCls, (NativeNode)var4_8);
                ObjectMethodMatchConf mf = ObjectUtil.findMethod(targetCls, method, parameterType);
                if (mf == null) {
                    throw new BeetlException("NATIVE_CALL_INVALID", "\u6839\u636e\u53c2\u6570\u672a\u627e\u5230\u5339\u914d\u7684\u65b9\u6cd5" + method + BeetlUtil.getParameterDescription(parameterType)).pushToken(GrammarToken.createToken(this.token.text, this.token.line));
                }
                if (targetObj == null && !Modifier.isStatic(mf.method.getModifiers())) {
                    throw new BeetlException("NULL").pushToken(GrammarToken.createToken(this.token.text, this.token.line));
                }
                try {
                    targetObj = ObjectUtil.invoke(targetObj, mf, args);
                    targetCls = targetObj == null ? null : targetObj.getClass();
                }
                catch (SecurityException e) {
                    throw new BeetlException("NATIVE_CALL_EXCEPTION", "\u4e0d\u80fd\u8c03\u7528\u65b9\u6cd5", e).pushToken(GrammarToken.createToken(method, this.token.line));
                }
                catch (IllegalArgumentException e) {
                    throw new BeetlException("NATIVE_CALL_EXCEPTION", "\u9519\u8bef\u7684\u53c2\u6570", e).pushToken(GrammarToken.createToken(method, this.token.line));
                }
                catch (IllegalAccessException e) {
                    throw new BeetlException("NATIVE_CALL_EXCEPTION", "\u65e0\u6cd5\u8bbf\u95ee\u65b9\u6cd5", e).pushToken(GrammarToken.createToken(method, this.token.line));
                }
                catch (InvocationTargetException e) {
                    throw new BeetlException("NATIVE_CALL_EXCEPTION", "\u5185\u90e8\u8c03\u7528\u62a5\u9519", e.getTargetException()).pushToken(GrammarToken.createToken(method, this.token.line));
                }
            }
            NativeNode nativeNode = node;
        }
        return targetObj;
    }

    private void checkNull(Object o, NativeNode node) {
        if (o == null) {
            throw new BeetlException("NULL").pushToken(GrammarToken.createToken(node.getName(), this.token.line));
        }
    }

    private void checkPermit(Context ctx, Class targetCls, Object targetObj, String method) {
        if (targetCls == null) {
            return;
        }
        NativeSecurityManager securityManager = ctx.gt.getNativeSecurity();
        if (securityManager == null) {
            return;
        }
        if (!securityManager.permit(ctx.template.program.res.getId(), targetCls, targetObj, method)) {
            throw new BeetlException("NATIVE_SECUARITY_EXCEPTION").pushToken(GrammarToken.createToken(method, this.token.line));
        }
    }
}

