/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.platform_services.open_service_broker.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.platform_services.common.SdkCommon;
import com.ibm.cloud.platform_services.open_service_broker.v1.model.DeleteServiceBindingOptions;
import com.ibm.cloud.platform_services.open_service_broker.v1.model.DeleteServiceInstanceOptions;
import com.ibm.cloud.platform_services.open_service_broker.v1.model.GetLastOperationOptions;
import com.ibm.cloud.platform_services.open_service_broker.v1.model.GetServiceInstanceStateOptions;
import com.ibm.cloud.platform_services.open_service_broker.v1.model.ListCatalogOptions;
import com.ibm.cloud.platform_services.open_service_broker.v1.model.ReplaceServiceBindingOptions;
import com.ibm.cloud.platform_services.open_service_broker.v1.model.ReplaceServiceInstanceOptions;
import com.ibm.cloud.platform_services.open_service_broker.v1.model.ReplaceServiceInstanceStateOptions;
import com.ibm.cloud.platform_services.open_service_broker.v1.model.Resp1874644Root;
import com.ibm.cloud.platform_services.open_service_broker.v1.model.Resp1874650Root;
import com.ibm.cloud.platform_services.open_service_broker.v1.model.Resp2079872Root;
import com.ibm.cloud.platform_services.open_service_broker.v1.model.Resp2079874Root;
import com.ibm.cloud.platform_services.open_service_broker.v1.model.Resp2079876Root;
import com.ibm.cloud.platform_services.open_service_broker.v1.model.Resp2079894Root;
import com.ibm.cloud.platform_services.open_service_broker.v1.model.Resp2448145Root;
import com.ibm.cloud.platform_services.open_service_broker.v1.model.UpdateServiceInstanceOptions;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;

public class OpenServiceBroker
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "open_service_broker";

    public static OpenServiceBroker newInstance() {
        return OpenServiceBroker.newInstance(DEFAULT_SERVICE_NAME);
    }

    public static OpenServiceBroker newInstance(String serviceName) {
        Authenticator authenticator = ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName);
        OpenServiceBroker service = new OpenServiceBroker(serviceName, authenticator);
        service.configureService(serviceName);
        return service;
    }

    public OpenServiceBroker(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
    }

    public ServiceCall<Resp1874644Root> getServiceInstanceState(GetServiceInstanceStateOptions getServiceInstanceStateOptions) {
        Validator.notNull((Object)((Object)getServiceInstanceStateOptions), (String)"getServiceInstanceStateOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", getServiceInstanceStateOptions.instanceId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/bluemix_v1/service_instances/{instance_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getServiceInstanceState");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Resp1874644Root>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Resp2448145Root> replaceServiceInstanceState(ReplaceServiceInstanceStateOptions replaceServiceInstanceStateOptions) {
        Validator.notNull((Object)((Object)replaceServiceInstanceStateOptions), (String)"replaceServiceInstanceStateOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", replaceServiceInstanceStateOptions.instanceId());
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/bluemix_v1/service_instances/{instance_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"replaceServiceInstanceState");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (replaceServiceInstanceStateOptions.enabled() != null) {
            contentJson.addProperty("enabled", replaceServiceInstanceStateOptions.enabled());
        }
        if (replaceServiceInstanceStateOptions.initiatorId() != null) {
            contentJson.addProperty("initiator_id", replaceServiceInstanceStateOptions.initiatorId());
        }
        if (replaceServiceInstanceStateOptions.reasonCode() != null) {
            contentJson.addProperty("reason_code", replaceServiceInstanceStateOptions.reasonCode());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Resp2448145Root>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Resp2079872Root> replaceServiceInstance(ReplaceServiceInstanceOptions replaceServiceInstanceOptions) {
        Validator.notNull((Object)((Object)replaceServiceInstanceOptions), (String)"replaceServiceInstanceOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", replaceServiceInstanceOptions.instanceId());
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/service_instances/{instance_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"replaceServiceInstance");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (replaceServiceInstanceOptions.acceptsIncomplete() != null) {
            builder.query(new Object[]{"accepts_incomplete", String.valueOf(replaceServiceInstanceOptions.acceptsIncomplete())});
        }
        JsonObject contentJson = new JsonObject();
        if (replaceServiceInstanceOptions.context() != null) {
            contentJson.add("context", GsonSingleton.getGson().toJsonTree((Object)replaceServiceInstanceOptions.context()));
        }
        if (replaceServiceInstanceOptions.organizationGuid() != null) {
            contentJson.addProperty("organization_guid", replaceServiceInstanceOptions.organizationGuid());
        }
        if (replaceServiceInstanceOptions.parameters() != null) {
            contentJson.add("parameters", GsonSingleton.getGson().toJsonTree(replaceServiceInstanceOptions.parameters()));
        }
        if (replaceServiceInstanceOptions.planId() != null) {
            contentJson.addProperty("plan_id", replaceServiceInstanceOptions.planId());
        }
        if (replaceServiceInstanceOptions.serviceId() != null) {
            contentJson.addProperty("service_id", replaceServiceInstanceOptions.serviceId());
        }
        if (replaceServiceInstanceOptions.spaceGuid() != null) {
            contentJson.addProperty("space_guid", replaceServiceInstanceOptions.spaceGuid());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Resp2079872Root>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Resp2079874Root> updateServiceInstance(UpdateServiceInstanceOptions updateServiceInstanceOptions) {
        Validator.notNull((Object)((Object)updateServiceInstanceOptions), (String)"updateServiceInstanceOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", updateServiceInstanceOptions.instanceId());
        RequestBuilder builder = RequestBuilder.patch((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/service_instances/{instance_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"updateServiceInstance");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (updateServiceInstanceOptions.acceptsIncomplete() != null) {
            builder.query(new Object[]{"accepts_incomplete", String.valueOf(updateServiceInstanceOptions.acceptsIncomplete())});
        }
        JsonObject contentJson = new JsonObject();
        if (updateServiceInstanceOptions.context() != null) {
            contentJson.add("context", GsonSingleton.getGson().toJsonTree((Object)updateServiceInstanceOptions.context()));
        }
        if (updateServiceInstanceOptions.parameters() != null) {
            contentJson.add("parameters", GsonSingleton.getGson().toJsonTree(updateServiceInstanceOptions.parameters()));
        }
        if (updateServiceInstanceOptions.planId() != null) {
            contentJson.addProperty("plan_id", updateServiceInstanceOptions.planId());
        }
        if (updateServiceInstanceOptions.previousValues() != null) {
            contentJson.add("previous_values", GsonSingleton.getGson().toJsonTree(updateServiceInstanceOptions.previousValues()));
        }
        if (updateServiceInstanceOptions.serviceId() != null) {
            contentJson.addProperty("service_id", updateServiceInstanceOptions.serviceId());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Resp2079874Root>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Resp2079874Root> deleteServiceInstance(DeleteServiceInstanceOptions deleteServiceInstanceOptions) {
        Validator.notNull((Object)((Object)deleteServiceInstanceOptions), (String)"deleteServiceInstanceOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", deleteServiceInstanceOptions.instanceId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/service_instances/{instance_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteServiceInstance");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"service_id", String.valueOf(deleteServiceInstanceOptions.serviceId())});
        builder.query(new Object[]{"plan_id", String.valueOf(deleteServiceInstanceOptions.planId())});
        if (deleteServiceInstanceOptions.acceptsIncomplete() != null) {
            builder.query(new Object[]{"accepts_incomplete", String.valueOf(deleteServiceInstanceOptions.acceptsIncomplete())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Resp2079874Root>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Resp1874650Root> listCatalog(ListCatalogOptions listCatalogOptions) {
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/catalog"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listCatalog");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Resp1874650Root>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Resp1874650Root> listCatalog() {
        return this.listCatalog(null);
    }

    public ServiceCall<Resp2079894Root> getLastOperation(GetLastOperationOptions getLastOperationOptions) {
        Validator.notNull((Object)((Object)getLastOperationOptions), (String)"getLastOperationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", getLastOperationOptions.instanceId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/service_instances/{instance_id}/last_operation", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getLastOperation");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getLastOperationOptions.operation() != null) {
            builder.query(new Object[]{"operation", String.valueOf(getLastOperationOptions.operation())});
        }
        if (getLastOperationOptions.planId() != null) {
            builder.query(new Object[]{"plan_id", String.valueOf(getLastOperationOptions.planId())});
        }
        if (getLastOperationOptions.serviceId() != null) {
            builder.query(new Object[]{"service_id", String.valueOf(getLastOperationOptions.serviceId())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Resp2079894Root>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Resp2079876Root> replaceServiceBinding(ReplaceServiceBindingOptions replaceServiceBindingOptions) {
        Validator.notNull((Object)((Object)replaceServiceBindingOptions), (String)"replaceServiceBindingOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("binding_id", replaceServiceBindingOptions.bindingId());
        pathParamsMap.put("instance_id", replaceServiceBindingOptions.instanceId());
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/service_instances/{instance_id}/service_bindings/{binding_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"replaceServiceBinding");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (replaceServiceBindingOptions.bindResource() != null) {
            contentJson.add("bind_resource", GsonSingleton.getGson().toJsonTree((Object)replaceServiceBindingOptions.bindResource()));
        }
        if (replaceServiceBindingOptions.parameters() != null) {
            contentJson.add("parameters", GsonSingleton.getGson().toJsonTree(replaceServiceBindingOptions.parameters()));
        }
        if (replaceServiceBindingOptions.planId() != null) {
            contentJson.addProperty("plan_id", replaceServiceBindingOptions.planId());
        }
        if (replaceServiceBindingOptions.serviceId() != null) {
            contentJson.addProperty("service_id", replaceServiceBindingOptions.serviceId());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Resp2079876Root>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteServiceBinding(DeleteServiceBindingOptions deleteServiceBindingOptions) {
        Validator.notNull((Object)((Object)deleteServiceBindingOptions), (String)"deleteServiceBindingOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("binding_id", deleteServiceBindingOptions.bindingId());
        pathParamsMap.put("instance_id", deleteServiceBindingOptions.instanceId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/service_instances/{instance_id}/service_bindings/{binding_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteServiceBinding");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"plan_id", String.valueOf(deleteServiceBindingOptions.planId())});
        builder.query(new Object[]{"service_id", String.valueOf(deleteServiceBindingOptions.serviceId())});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

