/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.platform_services.open_service_broker.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class DeleteServiceInstanceOptions
extends GenericModel {
    protected String serviceId;
    protected String planId;
    protected String instanceId;
    protected Boolean acceptsIncomplete;

    protected DeleteServiceInstanceOptions(Builder builder) {
        Validator.notNull((Object)builder.serviceId, (String)"serviceId cannot be null");
        Validator.notNull((Object)builder.planId, (String)"planId cannot be null");
        Validator.notEmpty((String)builder.instanceId, (String)"instanceId cannot be empty");
        this.serviceId = builder.serviceId;
        this.planId = builder.planId;
        this.instanceId = builder.instanceId;
        this.acceptsIncomplete = builder.acceptsIncomplete;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String serviceId() {
        return this.serviceId;
    }

    public String planId() {
        return this.planId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Boolean acceptsIncomplete() {
        return this.acceptsIncomplete;
    }

    public static class Builder {
        private String serviceId;
        private String planId;
        private String instanceId;
        private Boolean acceptsIncomplete;

        private Builder(DeleteServiceInstanceOptions deleteServiceInstanceOptions) {
            this.serviceId = deleteServiceInstanceOptions.serviceId;
            this.planId = deleteServiceInstanceOptions.planId;
            this.instanceId = deleteServiceInstanceOptions.instanceId;
            this.acceptsIncomplete = deleteServiceInstanceOptions.acceptsIncomplete;
        }

        public Builder() {
        }

        public Builder(String serviceId, String planId, String instanceId) {
            this.serviceId = serviceId;
            this.planId = planId;
            this.instanceId = instanceId;
        }

        public DeleteServiceInstanceOptions build() {
            return new DeleteServiceInstanceOptions(this);
        }

        public Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public Builder planId(String planId) {
            this.planId = planId;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder acceptsIncomplete(Boolean acceptsIncomplete) {
            this.acceptsIncomplete = acceptsIncomplete;
            return this;
        }
    }
}

