/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.standalone;

import com.icegreen.greenmail.configuration.GreenMailConfiguration;
import com.icegreen.greenmail.standalone.GreenMailApiResource;
import com.icegreen.greenmail.standalone.JacksonObjectMapperProvider;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import com.sun.net.httpserver.HttpServer;
import java.net.URI;
import java.util.Properties;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.jdkhttp.JdkHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class GreenMailApiServerBuilder {
    public static final String GREENMAIL_API_HOSTNAME = "greenmail.api.hostname";
    public static final String GREENMAIL_API_PORT = "greenmail.api.port";
    public static final int GREENMAIL_API_PORT_DEFAULT = 8080;
    private String address;
    private int port = 8080;
    private GreenMail greenMail;
    private ServerSetup[] serverSetups;
    private GreenMailConfiguration configuration;

    public GreenMailApiServerBuilder configure(Properties properties) {
        if (properties.containsKey(GREENMAIL_API_HOSTNAME) || properties.containsKey("greenmail.setup.all") || properties.containsKey("greenmail.setup.test.all") || properties.containsKey("greenmail.hostname")) {
            this.address = properties.containsKey("greenmail.hostname") ? properties.getProperty("greenmail.hostname") : ServerSetup.getLocalHostAddress();
            this.address = properties.getProperty(GREENMAIL_API_HOSTNAME, this.address);
        }
        if (properties.containsKey(GREENMAIL_API_PORT)) {
            try {
                this.port = Integer.parseInt(properties.getProperty(GREENMAIL_API_PORT));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Can not parse port address value " + properties.getProperty(GREENMAIL_API_PORT) + " of system property " + GREENMAIL_API_PORT, ex);
            }
        }
        return this;
    }

    public boolean isEnabled() {
        return null != this.address && 0 != this.port;
    }

    public GreenMailApiServerBuilder withGreenMail(GreenMail greenMail, ServerSetup[] serverSetups, GreenMailConfiguration configuration) {
        this.greenMail = greenMail;
        this.serverSetups = serverSetups;
        this.configuration = configuration;
        return this;
    }

    public ApiServer build() {
        if (!this.isEnabled()) {
            throw new IllegalStateException("GreenMail API service is not enabled, please configure greenmail.api.hostname and greenmail.api.port");
        }
        URI baseUri = UriBuilder.fromUri("http://" + this.address + "/").port(this.port).build(new Object[0]);
        GreenMailApiResource greenMailApiResource = new GreenMailApiResource(this.greenMail, this.serverSetups, this.configuration);
        return new GreenMailApiJdkServer(baseUri, greenMailApiResource);
    }

    public static class GreenMailApiJdkServer
    implements ApiServer {
        private final URI baseUri;
        private final ResourceConfig resourceConfig;
        private HttpServer httpServer;

        public GreenMailApiJdkServer(URI baseUri, GreenMailApiResource greenMailApiResource) {
            this.baseUri = baseUri;
            this.resourceConfig = new ResourceConfig();
            this.resourceConfig.registerInstances(greenMailApiResource);
            this.resourceConfig.register((Class)JacksonFeature.class);
            this.resourceConfig.register((Class)JacksonObjectMapperProvider.class);
        }

        @Override
        public URI getUri() {
            return this.baseUri;
        }

        @Override
        public void start() {
            this.httpServer = JdkHttpServerFactory.createHttpServer(this.baseUri, this.resourceConfig);
        }

        @Override
        public void stop() {
            this.httpServer.stop(0);
        }
    }

    static interface ApiServer {
        public URI getUri();

        public void start();

        public void stop();
    }
}

