/*
 * Decompiled with CFR 0.152.
 */
package com.julienviet.childprocess.impl;

import com.julienviet.childprocess.Process;
import com.julienviet.childprocess.StreamInput;
import com.julienviet.childprocess.StreamOutput;
import com.julienviet.childprocess.impl.ProcessStreamInput;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessBuilder;
import com.zaxxer.nuprocess.NuProcessHandler;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;

public class ProcessImpl
implements NuProcessHandler,
Process,
StreamOutput {
    private static final int OPEN = 0;
    private static final int CLOSING = 1;
    private static final int CLOSED = 2;
    private NuProcessBuilder builder;
    private int stdinStatus = 0;
    private final ArrayDeque<Buffer> stdinPending = new ArrayDeque();
    private int stdinSize;
    private int stdinMaxSize = 1024;
    private Handler<Void> drainHandler;
    private final Context context;
    private final ProcessStreamInput stdout;
    private final ProcessStreamInput stderr;
    private Handler<Process> processHandler;
    private Handler<Integer> exitHandler;
    private NuProcess process;
    private boolean wantWrite;

    public ProcessImpl(Context context, NuProcessBuilder builder) {
        this.context = context;
        this.stdout = new ProcessStreamInput(context);
        this.stderr = new ProcessStreamInput(context);
        this.builder = builder;
    }

    @Override
    public synchronized void start() {
        this.start((Handler<Process>)((Handler)p -> {}));
    }

    @Override
    public synchronized void start(Handler<Process> handler) {
        if (this.processHandler != null) {
            throw new IllegalStateException();
        }
        this.processHandler = handler;
        this.builder.setProcessListener((NuProcessHandler)this);
        this.context.runOnContext(v -> this.builder.start());
    }

    @Override
    public synchronized Process exitHandler(Handler<Integer> handler) {
        this.exitHandler = handler;
        return this;
    }

    @Override
    public synchronized Integer pid() {
        return this.process != null ? Integer.valueOf(this.process.getPID()) : null;
    }

    @Override
    public StreamOutput stdin() {
        return this;
    }

    @Override
    public StreamInput stdout() {
        return this.stdout;
    }

    @Override
    public StreamInput stderr() {
        return this.stderr;
    }

    @Override
    public StreamOutput exceptionHandler(Handler<Throwable> handler) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamOutput write(Buffer buffer) {
        boolean hasPending;
        ProcessImpl processImpl = this;
        synchronized (processImpl) {
            if (this.stdinStatus == 1 || this.stdinStatus == 2) {
                throw new IllegalStateException();
            }
            this.stdinPending.add(buffer);
            this.stdinSize += buffer.length();
            hasPending = this.stdinSize > 0;
        }
        if (this.process != null && hasPending && !this.wantWrite) {
            this.wantWrite = true;
            this.process.wantWrite();
        }
        return this;
    }

    @Override
    public synchronized StreamOutput setWriteQueueMaxSize(int i) {
        this.stdinMaxSize = i;
        return this;
    }

    @Override
    public StreamOutput drainHandler(Handler<Void> handler) {
        this.drainHandler = handler;
        this.checkDrained();
        return this;
    }

    public synchronized boolean writeQueueFull() {
        return this.stdinSize > this.stdinMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ProcessImpl processImpl = this;
        synchronized (processImpl) {
            switch (this.stdinStatus) {
                case 0: {
                    if (this.process != null) {
                        if (this.stdinSize == 0) {
                            this.stdinStatus = 2;
                            break;
                        }
                        this.stdinStatus = 1;
                        return;
                    }
                    this.stdinStatus = 1;
                    return;
                }
                default: {
                    return;
                }
            }
        }
        this.process.closeStdin(false);
    }

    public void onPreStart(NuProcess nuProcess) {
    }

    public synchronized void onStart(NuProcess nuProcess) {
        this.process = nuProcess;
        this.stdinStatus = 0;
        if (this.stdinPending.size() > 0) {
            this.wantWrite = true;
            this.process.wantWrite();
        }
        this.context.runOnContext(v -> this.processHandler.handle((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onExit(int exitCode) {
        if (this.process == null) {
            this.context.runOnContext(v -> {
                if (this.processHandler != null) {
                    this.processHandler.handle((Object)this);
                }
                this.handleExit(exitCode);
            });
        } else {
            this.process = null;
            ProcessImpl processImpl = this;
            synchronized (processImpl) {
                this.stdinStatus = 2;
            }
            this.handleExit(exitCode);
        }
    }

    private void handleExit(int exitCode) {
        Handler<Integer> handler = this.exitHandler;
        if (handler != null) {
            this.context.runOnContext(v -> handler.handle((Object)exitCode));
        }
    }

    public void onStdout(ByteBuffer byteBuffer, boolean closed) {
        if (byteBuffer != null && byteBuffer.remaining() > 0) {
            this.stdout.write(byteBuffer);
        }
        if (closed) {
            this.stdout.close();
        }
    }

    public void onStderr(ByteBuffer byteBuffer, boolean closed) {
        if (byteBuffer != null && byteBuffer.remaining() > 0) {
            this.stderr.write(byteBuffer);
        }
        if (closed) {
            this.stderr.close();
        }
    }

    public synchronized boolean onStdinReady(ByteBuffer byteBuffer) {
        Buffer buffer;
        while (byteBuffer.remaining() > 0 && (buffer = this.stdinPending.poll()) != null) {
            byte[] bytes;
            if (buffer.length() <= byteBuffer.remaining()) {
                bytes = buffer.getBytes();
            } else {
                bytes = buffer.getBytes(0, byteBuffer.remaining());
                this.stdinPending.addFirst(buffer.slice(byteBuffer.remaining(), buffer.length()));
            }
            byteBuffer.put(bytes);
            this.stdinSize -= bytes.length;
        }
        byteBuffer.flip();
        this.context.runOnContext(v -> this.checkDrained());
        if (this.stdinSize > 0) {
            return true;
        }
        this.wantWrite = false;
        if (this.stdinStatus == 1) {
            this.stdinStatus = 2;
            this.process.closeStdin(false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDrained() {
        ProcessImpl processImpl = this;
        synchronized (processImpl) {
            if (this.stdinSize >= this.stdinMaxSize / 2) {
                return;
            }
        }
        if (this.drainHandler != null) {
            Handler<Void> handler = this.drainHandler;
            this.drainHandler = null;
            handler.handle(null);
        }
    }

    @Override
    public void kill(boolean force) {
        if (this.process != null) {
            this.process.destroy(force);
        }
    }

    @Override
    public boolean isRunning() {
        return this.process != null && this.process.isRunning();
    }
}

