/*
 * Decompiled with CFR 0.152.
 */
package com.julienviet.childprocess.impl;

import com.julienviet.childprocess.StreamInput;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import java.nio.ByteBuffer;

public class ProcessStreamInput
implements StreamInput {
    private final Context context;
    private Handler<Buffer> handler;
    private Handler<Void> endHandler;

    ProcessStreamInput(Context context) {
        this.context = context;
    }

    synchronized void write(ByteBuffer byteBuffer) {
        this.sendBuffer(byteBuffer);
    }

    void close() {
        this.context.runOnContext(v -> {
            if (this.endHandler != null) {
                this.endHandler.handle(null);
            }
        });
    }

    private void sendBuffer(ByteBuffer byteBuffer) {
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        Buffer buffer = Buffer.buffer((byte[])bytes);
        this.context.runOnContext(v -> {
            if (this.handler != null) {
                this.handler.handle((Object)buffer);
            }
        });
    }

    @Override
    public StreamInput exceptionHandler(Handler<Throwable> handler) {
        return this;
    }

    @Override
    public StreamInput handler(Handler<Buffer> handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public StreamInput endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }
}

