require 'vertx/buffer'
require 'vertx/stream_base'
require 'vertx/util/utils.rb'
# Generated from com.julienviet.childprocess.StreamInput
module Childprocess
  #  The input of a process: a stream of .
  class StreamInput
    include ::Vertx::StreamBase
    # @private
    # @param j_del [::Childprocess::StreamInput] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Childprocess::StreamInput] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == StreamInput
    end
    def @@j_api_type.wrap(obj)
      StreamInput.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::ComJulienvietChildprocess::StreamInput.java_class
    end
    #  Set an exception handler on the read stream.
    # @yield the exception handler
    # @return [self]
    def exception_handler
      if block_given?
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    #  Set a buffer handler. As bytes are read, the handler will be called with the data.
    # @yield 
    # @return [self]
    def handler
      if block_given?
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling handler()"
    end
    #  Set an end handler. Once the stream has ended, and there is no more data to be read, this handler will be called.
    # @yield 
    # @return [self]
    def end_handler
      if block_given?
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling end_handler()"
    end
  end
end
