// Licensed to the Software Freedom Conservancy (SFC) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The SFC licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

/*
 * Copied here by jBrowserDriver to support Selenium 3 and 4. Selenium 4 does not have this file.
 */

package org.openqa.selenium;

/**
 * Represents the type of a new browser window that may be created.
 */
public enum WindowType {

  WINDOW ("window"),
  TAB ("tab"),
  ;

  private String text;
  
  WindowType(String text) {
    this.text = text;
  }

  @Override
  public String toString() {
    return String.valueOf(text);
  }

  public static WindowType fromString(String text) {
    if (text != null) {
      for (WindowType b : WindowType.values()) {
        if (text.equalsIgnoreCase(b.text)) {
          return b;
        }
      }
    }
    return null;
  }
}
