/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher;

import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.code.JavaCodeBase;
import com.manydesigns.portofino.dispatcher.Resource;
import com.manydesigns.portofino.dispatcher.ResourceResolver;
import com.manydesigns.portofino.dispatcher.Root;
import com.manydesigns.portofino.dispatcher.resolvers.CachingResourceResolver;
import com.manydesigns.portofino.dispatcher.resolvers.JavaResourceResolver;
import com.manydesigns.portofino.dispatcher.resolvers.ResourceResolvers;
import com.manydesigns.portofino.dispatcher.swagger.DocumentedApiRoot;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DispatcherInitializer {
    protected FileObject applicationRoot;
    protected Configuration configuration;
    protected CodeBase codeBase;
    private static final Logger logger = LoggerFactory.getLogger(DispatcherInitializer.class);

    public FileObject getApplicationRoot() {
        return this.applicationRoot;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public CodeBase getCodeBase() {
        return this.codeBase;
    }

    public void initialize() {
        String applicationDirectoryPath = this.getApplicationDirectoryPath();
        if (applicationDirectoryPath != null) {
            try {
                this.applicationRoot = VFS.getManager().resolveFile(applicationDirectoryPath);
                if (this.applicationRoot.getType() != FileType.FOLDER) {
                    logger.error("Configured application directory " + applicationDirectoryPath + " is not a directory");
                    this.applicationRoot = null;
                }
            }
            catch (FileSystemException e) {
                logger.error("Configured application directory " + applicationDirectoryPath + " is not valid", (Throwable)e);
            }
        }
        if (this.applicationRoot == null) {
            try {
                this.applicationRoot = this.getDefaultApplicationRoot();
            }
            catch (FileSystemException e) {
                this.initializationFailed((Exception)((Object)e));
            }
        }
        logger.info("Application directory: {}", (Object)this.applicationRoot);
        try {
            this.loadConfiguration();
        }
        catch (Exception e) {
            this.initializationFailed(e);
        }
        String actionsDirectory = this.getConfiguration().getString("portofino.actions.path", "actions");
        this.codeBase = this.initApplicationRoot(actionsDirectory);
        logger.info("Application initialized.");
    }

    protected abstract FileObject getDefaultApplicationRoot() throws FileSystemException;

    protected abstract String getApplicationDirectoryPath();

    protected void loadConfiguration() throws FileSystemException, ConfigurationException {
        FileObject configurationFile = this.applicationRoot.getChild("portofino.properties");
        CombinedConfiguration compositeConfiguration = new CombinedConfiguration();
        if (configurationFile != null) {
            Configurations configurations = new Configurations();
            PropertiesConfiguration configuration = configurations.properties(configurationFile.getURL());
            FileObject localConfigurationFile = this.applicationRoot.getChild("portofino-local.properties");
            if (localConfigurationFile != null && localConfigurationFile.exists() && localConfigurationFile.getType() == FileType.FILE) {
                logger.info("Local configuration found: {}", (Object)localConfigurationFile);
                PropertiesConfiguration localConfiguration = configurations.properties(localConfigurationFile.getURL());
                compositeConfiguration.addConfiguration((Configuration)localConfiguration);
            }
            compositeConfiguration.addConfiguration((Configuration)configuration);
            this.configuration = compositeConfiguration;
        } else {
            this.configuration = new PropertiesConfiguration();
            logger.warn("portofino.properties file not found in " + this.applicationRoot);
        }
    }

    protected CodeBase initApplicationRoot(String actionsDirectoryName) {
        try {
            FileObject actionsDirectory = this.applicationRoot.getChild(actionsDirectoryName);
            if (actionsDirectory == null || actionsDirectory.getType() != FileType.FOLDER) {
                this.initializationFailed(new Exception("Not a directory: " + actionsDirectoryName));
            }
            CodeBase codeBase = this.createCodeBase();
            ResourceResolvers resourceResolver = new ResourceResolvers();
            this.configureResourceResolvers(resourceResolver, codeBase);
            DocumentedApiRoot.setRootFactory(() -> this.getRoot(actionsDirectory, resourceResolver));
            return codeBase;
        }
        catch (Exception e) {
            this.initializationFailed(e);
            return null;
        }
    }

    protected CodeBase createCodeBase() throws IOException {
        JavaCodeBase javaCodeBase;
        FileObject codeBaseRoot = this.getCodeBaseRoot();
        JavaCodeBase codeBase = javaCodeBase = new JavaCodeBase(codeBaseRoot, null, this.getClass().getClassLoader());
        try {
            Class<?> gcb = Class.forName("com.manydesigns.portofino.code.GroovyCodeBase");
            Constructor<?> gcbConstructor = gcb.getConstructor(FileObject.class, CodeBase.class);
            codeBase = (CodeBase)gcbConstructor.newInstance(codeBaseRoot, javaCodeBase);
            logger.info("Groovy is available");
        }
        catch (Exception e) {
            logger.debug("Groovy not available", (Throwable)e);
        }
        return codeBase;
    }

    protected FileObject getCodeBaseRoot() throws FileSystemException {
        return VFS.getManager().resolveFile("res:com").getParent();
    }

    protected void configureResourceResolvers(ResourceResolvers resourceResolver, CodeBase codeBase) {
        resourceResolver.resourceResolvers.add(new JavaResourceResolver(codeBase));
        this.addResourceResolver(resourceResolver, "com.manydesigns.portofino.dispatcher.resolvers.GroovyResourceResolver", codeBase, false);
        this.addResourceResolver(resourceResolver, "com.manydesigns.portofino.dispatcher.resolvers.JacksonResourceResolver", codeBase, true);
    }

    protected Resource getRoot(FileObject actionsDirectory, ResourceResolvers resourceResolver) throws Exception {
        return Root.get(actionsDirectory, resourceResolver);
    }

    protected void addResourceResolver(ResourceResolvers resourceResolver, String className, CodeBase codeBase, boolean caching) {
        try {
            ResourceResolver resolver;
            Class<?> resClass = Class.forName(className);
            try {
                Constructor<?> resClassConstructor = resClass.getConstructor(CodeBase.class);
                resolver = (ResourceResolver)resClassConstructor.newInstance(codeBase);
            }
            catch (Exception e) {
                logger.debug("Constructor from CodeBase not available", (Throwable)e);
                resolver = (ResourceResolver)resClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (caching) {
                resolver = new CachingResourceResolver(resolver);
            }
            resourceResolver.resourceResolvers.add(resolver);
        }
        catch (Exception e) {
            logger.debug(className + " not available", (Throwable)e);
        }
    }

    protected void initializationFailed(Exception e) {
        logger.error("Could not initialize application", (Throwable)e);
        throw new RuntimeException(e);
    }
}

