/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest;

import com.microsoft.azure.kusto.ingest.Ensure;
import com.microsoft.azure.kusto.ingest.IngestionProperties;
import com.microsoft.azure.kusto.ingest.source.CompressionType;
import com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobOutputStream;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.queue.CloudQueue;
import com.microsoft.azure.storage.queue.CloudQueueMessage;
import com.microsoft.azure.storage.table.CloudTable;
import com.microsoft.azure.storage.table.TableEntity;
import com.microsoft.azure.storage.table.TableOperation;
import com.microsoft.azure.storage.table.TableServiceEntity;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AzureStorageClient {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int GZIP_BUFFER_SIZE = 16384;
    private static final int STREAM_BUFFER_SIZE = 16384;

    AzureStorageClient() {
    }

    void postMessageToQueue(String queuePath, String content) throws StorageException, URISyntaxException {
        Ensure.stringIsNotBlank(queuePath, "queuePath");
        Ensure.stringIsNotBlank(content, "content");
        CloudQueue queue = new CloudQueue(new URI(queuePath));
        CloudQueueMessage queueMessage = new CloudQueueMessage(content);
        queue.addMessage(queueMessage);
    }

    void azureTableInsertEntity(String tableUri, TableServiceEntity entity) throws StorageException, URISyntaxException {
        Ensure.stringIsNotBlank(tableUri, "tableUri");
        Ensure.argIsNotNull(entity, "entity");
        CloudTable table = new CloudTable(new URI(tableUri));
        TableOperation insert = TableOperation.insert((TableEntity)entity);
        table.execute(insert);
    }

    CloudBlockBlob uploadLocalFileToBlob(String filePath, String blobName, String storageUri, IngestionProperties.DATA_FORMAT dataFormat) throws URISyntaxException, StorageException, IOException {
        Ensure.fileExists(filePath);
        CompressionType sourceCompressionType = AzureStorageClient.getCompression(filePath);
        return this.uploadLocalFileToBlob(filePath, blobName, storageUri, AzureStorageClient.shouldCompress(sourceCompressionType, dataFormat.name()));
    }

    CloudBlockBlob uploadLocalFileToBlob(String filePath, String blobName, String storageUri, Boolean shouldCompress) throws URISyntaxException, StorageException, IOException {
        log.debug("uploadLocalFileToBlob: filePath: {}, blobName: {}, storageUri: {}", new Object[]{filePath, blobName, storageUri});
        Ensure.fileExists(filePath);
        Ensure.stringIsNotBlank(blobName, "blobName");
        Ensure.stringIsNotBlank(storageUri, "storageUri");
        CloudBlobContainer container = new CloudBlobContainer(new URI(storageUri));
        CloudBlockBlob blob = container.getBlockBlobReference(blobName);
        if (shouldCompress.booleanValue()) {
            this.compressAndUploadFileToBlob(filePath, blob);
        } else {
            File file = new File(filePath);
            this.uploadFileToBlob(file, blob);
        }
        return blob;
    }

    void compressAndUploadFileToBlob(String filePath, CloudBlockBlob blob) throws IOException, StorageException {
        Ensure.fileExists(filePath);
        Ensure.argIsNotNull(blob, "blob");
        InputStream fin = Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);
        BlobOutputStream bos = blob.openOutputStream();
        GZIPOutputStream gzout = new GZIPOutputStream((OutputStream)bos);
        this.copyStream(fin, gzout, 16384);
        gzout.close();
        fin.close();
    }

    void uploadFileToBlob(File sourceFile, CloudBlockBlob blob) throws IOException, StorageException {
        Ensure.argIsNotNull(blob, "blob");
        Ensure.fileExists(sourceFile, "sourceFile");
        blob.uploadFromFile(sourceFile.getAbsolutePath());
    }

    CloudBlockBlob uploadStreamToBlob(InputStream inputStream, String blobName, String storageUri, boolean shouldCompress) throws IOException, URISyntaxException, StorageException {
        log.debug("uploadStreamToBlob: blobName: {}, storageUri: {}", (Object)blobName, (Object)storageUri);
        Ensure.argIsNotNull(inputStream, "inputStream");
        Ensure.stringIsNotBlank(blobName, "blobName");
        Ensure.stringIsNotBlank(storageUri, "storageUri");
        CloudBlobContainer container = new CloudBlobContainer(new URI(storageUri));
        CloudBlockBlob blob = container.getBlockBlobReference(blobName);
        if (shouldCompress) {
            this.compressAndUploadStream(inputStream, blob);
        } else {
            this.uploadStream(inputStream, blob);
        }
        return blob;
    }

    void uploadStream(InputStream inputStream, CloudBlockBlob blob) throws StorageException, IOException {
        Ensure.argIsNotNull(inputStream, "inputStream");
        Ensure.argIsNotNull(blob, "blob");
        BlobOutputStream bos = blob.openOutputStream();
        this.copyStream(inputStream, (OutputStream)bos, 16384);
        bos.close();
    }

    void compressAndUploadStream(InputStream inputStream, CloudBlockBlob blob) throws StorageException, IOException {
        Ensure.argIsNotNull(inputStream, "inputStream");
        Ensure.argIsNotNull(blob, "blob");
        BlobOutputStream bos = blob.openOutputStream();
        GZIPOutputStream gzout = new GZIPOutputStream((OutputStream)bos);
        this.copyStream(inputStream, gzout, 16384);
        gzout.close();
    }

    private void copyStream(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        int length;
        byte[] buffer = new byte[bufferSize];
        while ((length = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, length);
        }
    }

    String getBlobPathWithSas(CloudBlockBlob blob) {
        Ensure.argIsNotNull(blob, "blob");
        StorageCredentialsSharedAccessSignature signature = (StorageCredentialsSharedAccessSignature)blob.getServiceClient().getCredentials();
        return blob.getStorageUri().getPrimaryUri().toString() + "?" + signature.getToken();
    }

    long getBlobSize(String blobPath) throws StorageException, URISyntaxException {
        Ensure.stringIsNotBlank(blobPath, "blobPath");
        CloudBlockBlob blockBlob = new CloudBlockBlob(new URI(blobPath));
        blockBlob.downloadAttributes();
        return blockBlob.getProperties().getLength();
    }

    static CompressionType getCompression(String fileName) {
        if (fileName.endsWith(".gz")) {
            return CompressionType.gz;
        }
        if (fileName.endsWith(".zip")) {
            return CompressionType.zip;
        }
        return null;
    }

    static boolean shouldCompress(CompressionType sourceCompressionType, String data_format) {
        return sourceCompressionType == null && (data_format == null || !data_format.equals(IngestionProperties.DATA_FORMAT.parquet.name()) && !data_format.equals(IngestionProperties.DATA_FORMAT.orc.name()));
    }
}

