/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest;

import com.microsoft.azure.kusto.ingest.IngestionMapping;
import com.microsoft.azure.kusto.ingest.MappingConsts;
import com.microsoft.azure.kusto.ingest.TransformationMethod;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ColumnMapping
implements Serializable {
    public String columnName;
    public String columnType;
    public Map<String, String> properties;

    public ColumnMapping(String columnName, String cslDataType) {
        this(columnName, cslDataType, new HashMap<String, String>());
    }

    public ColumnMapping(String columnName, String cslDataType, Map<String, String> properties) {
        this.columnName = columnName;
        this.columnType = cslDataType;
        this.properties = properties;
    }

    public ColumnMapping(ColumnMapping other) {
        this.columnName = other.columnName;
        this.columnType = other.columnType;
        this.properties = new HashMap<String, String>(other.properties);
    }

    public void setPath(String path) {
        this.properties.put(MappingConsts.PATH.getName(), path);
    }

    public String getPath() {
        return this.properties.get(MappingConsts.PATH.getName());
    }

    public void setTransform(TransformationMethod transform) {
        this.properties.put(MappingConsts.TRANSFORMATION_METHOD.getName(), transform.name());
    }

    public TransformationMethod getTransform() {
        String transform = this.properties.get(MappingConsts.TRANSFORMATION_METHOD.getName());
        return StringUtils.isEmpty((CharSequence)transform) ? null : TransformationMethod.valueOf(transform);
    }

    public void setOrdinal(Integer ordinal) {
        this.properties.put(MappingConsts.ORDINAL.getName(), String.valueOf(ordinal));
    }

    Integer getOrdinal() {
        String ordinal = this.properties.get(MappingConsts.ORDINAL.getName());
        return StringUtils.isEmpty((CharSequence)ordinal) ? null : Integer.valueOf(ordinal);
    }

    public void setConstantValue(String constValue) {
        this.properties.put(MappingConsts.CONST_VALUE.getName(), constValue);
    }

    public String getConstantValue() {
        return this.properties.get(MappingConsts.CONST_VALUE.getName());
    }

    public void setField(String field) {
        this.properties.put(MappingConsts.FIELD_NAME.getName(), field);
    }

    String setField() {
        return this.properties.get(MappingConsts.FIELD_NAME.getName());
    }

    public void setColumns(String columns) {
        this.properties.put(MappingConsts.COLUMNS.getName(), columns);
    }

    public String getColumns() {
        return this.properties.get(MappingConsts.COLUMNS.getName());
    }

    public void setStorageDataType(String dataType) {
        this.properties.put(MappingConsts.STORAGE_DATA_TYPE.getName(), dataType);
    }

    public String getStorageDataType() {
        return this.properties.get(MappingConsts.STORAGE_DATA_TYPE.getName());
    }

    public boolean isValid(IngestionMapping.IngestionMappingKind mappingKind) {
        switch (mappingKind) {
            case Csv: {
                return !StringUtils.isEmpty((CharSequence)this.columnName);
            }
            case Json: 
            case Parquet: 
            case Orc: {
                TransformationMethod transformationMethod = this.getTransform();
                return !StringUtils.isEmpty((CharSequence)this.columnName) && (!StringUtils.isEmpty((CharSequence)this.getPath()) || transformationMethod == TransformationMethod.SourceLineNumber || transformationMethod == TransformationMethod.SourceLocation);
            }
            case Avro: 
            case ApacheAvro: {
                return !StringUtils.isEmpty((CharSequence)this.columnName) && !StringUtils.isEmpty((CharSequence)this.getColumns());
            }
        }
        return false;
    }
}

