/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest;

import com.microsoft.azure.kusto.ingest.exceptions.IngestionClientException;
import com.microsoft.azure.kusto.ingest.exceptions.IngestionServiceException;
import java.lang.invoke.MethodHandles;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IngestClientBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected String connectionDataSource;
    private String endpointServiceType;
    private String suggestedEndpointUri;
    public static final String INGEST_PREFIX = "ingest-";
    protected static final String WRONG_ENDPOINT_MESSAGE = "You are using '%s' client type, but the provided endpoint is of ServiceType '%s'. Initialize the client with the appropriate endpoint URI";

    protected void validateEndpointServiceType(String connectionDataSource, String expectedServiceType) throws IngestionServiceException, IngestionClientException {
        if (StringUtils.isBlank((CharSequence)this.endpointServiceType)) {
            this.endpointServiceType = this.retrieveServiceType();
        }
        if (!expectedServiceType.equals(this.endpointServiceType)) {
            String message = String.format(WRONG_ENDPOINT_MESSAGE, expectedServiceType, this.endpointServiceType);
            this.suggestedEndpointUri = this.generateEndpointSuggestion(this.suggestedEndpointUri, connectionDataSource);
            message = StringUtils.isNotBlank((CharSequence)this.suggestedEndpointUri) ? String.format("%s: '%s'", message, this.suggestedEndpointUri) : message + ".";
            throw new IngestionClientException(message);
        }
    }

    protected String generateEndpointSuggestion(String existingSuggestedEndpointUri, String dataSource) {
        if (existingSuggestedEndpointUri != null) {
            return existingSuggestedEndpointUri;
        }
        String endpointUriToSuggestStr = "";
        if (StringUtils.isNotBlank((CharSequence)dataSource)) {
            try {
                URIBuilder existingEndpoint = new URIBuilder(dataSource);
                endpointUriToSuggestStr = this.emendEndpointUri(existingEndpoint);
            }
            catch (URISyntaxException e) {
                log.error("Couldn't parse dataSource '{}', so no suggestion can be made.", (Object)dataSource, (Object)e);
            }
        }
        return endpointUriToSuggestStr;
    }

    protected abstract String retrieveServiceType() throws IngestionServiceException, IngestionClientException;

    protected abstract String emendEndpointUri(URIBuilder var1);
}

