/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest;

import com.microsoft.azure.kusto.data.auth.ConnectionStringBuilder;
import com.microsoft.azure.kusto.ingest.IngestClient;
import com.microsoft.azure.kusto.ingest.ManagedStreamingIngestClient;
import com.microsoft.azure.kusto.ingest.QueuedIngestClient;
import com.microsoft.azure.kusto.ingest.StreamingIngestClient;
import java.net.URISyntaxException;

public class IngestClientFactory {
    private IngestClientFactory() {
    }

    public static IngestClient createClient(ConnectionStringBuilder csb) throws URISyntaxException {
        return new QueuedIngestClient(csb);
    }

    public static StreamingIngestClient createStreamingIngestClient(ConnectionStringBuilder csb) throws URISyntaxException {
        return new StreamingIngestClient(csb);
    }

    public static ManagedStreamingIngestClient createManagedStreamingIngestClient(ConnectionStringBuilder dmConnectionStringBuilder, ConnectionStringBuilder engineConnectionStringBuilder) throws URISyntaxException {
        return new ManagedStreamingIngestClient(dmConnectionStringBuilder, engineConnectionStringBuilder);
    }
}

