/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest;

import com.microsoft.azure.kusto.ingest.ColumnMapping;
import java.util.Arrays;
import java.util.List;

public class IngestionMapping {
    private ColumnMapping[] columnMappings;
    private IngestionMappingKind ingestionMappingKind;
    private String ingestionMappingReference;
    public static final List<String> mappingRequiredFormats = Arrays.asList("json", "singlejson", "avro", "apacheavro", "parquet", "orc");

    public IngestionMapping() {
        this.ingestionMappingKind = IngestionMappingKind.unknown;
    }

    public IngestionMapping(String ingestionMappingReference, IngestionMappingKind ingestionMappingKind) {
        this.ingestionMappingReference = ingestionMappingReference;
        this.ingestionMappingKind = ingestionMappingKind;
    }

    public IngestionMapping(ColumnMapping[] columnMappings, IngestionMappingKind ingestionMappingKind) {
        this.columnMappings = columnMappings;
        this.ingestionMappingKind = ingestionMappingKind;
    }

    public IngestionMapping(IngestionMapping other) {
        this.ingestionMappingKind = other.ingestionMappingKind;
        this.ingestionMappingReference = other.ingestionMappingReference;
        this.columnMappings = (ColumnMapping[])Arrays.stream(other.columnMappings).map(ColumnMapping::new).toArray(ColumnMapping[]::new);
    }

    public void setIngestionMappingReference(String ingestionMappingReference, IngestionMappingKind ingestionMappingKind) {
        this.ingestionMappingReference = ingestionMappingReference;
        this.ingestionMappingKind = ingestionMappingKind;
    }

    public void setIngestionMapping(ColumnMapping[] columnMappings, IngestionMappingKind ingestionMappingKind) {
        this.columnMappings = columnMappings;
        this.ingestionMappingKind = ingestionMappingKind;
    }

    public IngestionMappingKind getIngestionMappingKind() {
        return this.ingestionMappingKind;
    }

    public String getIngestionMappingReference() {
        return this.ingestionMappingReference;
    }

    public ColumnMapping[] getColumnMappings() {
        return this.columnMappings;
    }

    public static enum IngestionMappingKind {
        unknown,
        Csv,
        Json,
        Parquet,
        Avro,
        ApacheAvro,
        Orc;

    }
}

