/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.kusto.ingest.ColumnMapping;
import com.microsoft.azure.kusto.ingest.Ensure;
import com.microsoft.azure.kusto.ingest.IngestionMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class IngestionProperties {
    private String databaseName;
    private String tableName;
    private boolean flushImmediately;
    private IngestionReportLevel reportLevel;
    private IngestionReportMethod reportMethod;
    private ArrayList<String> dropByTags;
    private ArrayList<String> ingestByTags;
    private ArrayList<String> additionalTags;
    private ArrayList<String> ingestIfNotExists;
    private IngestionMapping ingestionMapping;
    private Map<String, String> additionalProperties;

    public IngestionProperties(String databaseName, String tableName) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.reportLevel = IngestionReportLevel.FailuresOnly;
        this.reportMethod = IngestionReportMethod.Queue;
        this.flushImmediately = false;
        this.additionalProperties = new HashMap<String, String>();
        this.dropByTags = new ArrayList();
        this.ingestByTags = new ArrayList();
        this.ingestIfNotExists = new ArrayList();
        this.additionalTags = new ArrayList();
        this.ingestionMapping = new IngestionMapping();
    }

    public IngestionProperties(IngestionProperties other) {
        this.databaseName = other.databaseName;
        this.tableName = other.tableName;
        this.reportLevel = other.reportLevel;
        this.reportMethod = other.reportMethod;
        this.flushImmediately = other.flushImmediately;
        this.additionalProperties = new HashMap<String, String>(other.additionalProperties);
        this.dropByTags = new ArrayList<String>(other.dropByTags);
        this.ingestByTags = new ArrayList<String>(other.ingestByTags);
        this.ingestIfNotExists = new ArrayList<String>(other.ingestIfNotExists);
        this.additionalTags = new ArrayList<String>(other.additionalTags);
        this.ingestionMapping = new IngestionMapping(other.ingestionMapping);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean getFlushImmediately() {
        return this.flushImmediately;
    }

    public void setFlushImmediately(boolean flushImmediately) {
        this.flushImmediately = flushImmediately;
    }

    public IngestionReportLevel getReportLevel() {
        return this.reportLevel;
    }

    public void setReportLevel(IngestionReportLevel reportLevel) {
        this.reportLevel = reportLevel;
    }

    public IngestionReportMethod getReportMethod() {
        return this.reportMethod;
    }

    public void setReportMethod(IngestionReportMethod reportMethod) {
        this.reportMethod = reportMethod;
    }

    public ArrayList<String> getDropByTags() {
        return this.dropByTags;
    }

    public void setDropByTags(ArrayList<String> dropByTags) {
        this.dropByTags = dropByTags;
    }

    public ArrayList<String> getIngestByTags() {
        return this.ingestByTags;
    }

    public void setIngestByTags(ArrayList<String> ingestByTags) {
        this.ingestByTags = ingestByTags;
    }

    public ArrayList<String> getAdditionalTags() {
        return this.additionalTags;
    }

    public void setAdditionalTags(ArrayList<String> additionalTags) {
        this.additionalTags = additionalTags;
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public ArrayList<String> getIngestIfNotExists() {
        return this.ingestIfNotExists;
    }

    public void setIngestIfNotExists(ArrayList<String> ingestIfNotExists) {
        this.ingestIfNotExists = ingestIfNotExists;
    }

    Map<String, String> getIngestionProperties() throws IOException {
        ObjectMapper objectMapper;
        HashMap<String, String> fullAdditionalProperties = new HashMap<String, String>();
        if (!(this.dropByTags.isEmpty() && this.ingestByTags.isEmpty() && this.additionalTags.isEmpty())) {
            ArrayList<String> tags = new ArrayList<String>();
            if (!this.additionalTags.isEmpty()) {
                tags.addAll(this.additionalTags);
            }
            if (!this.ingestByTags.isEmpty()) {
                for (String t : this.ingestByTags) {
                    tags.add(String.format("%s%s", "ingest-by:", t));
                }
            }
            if (!this.dropByTags.isEmpty()) {
                for (String t : this.dropByTags) {
                    tags.add(String.format("%s%s", "drop-by:", t));
                }
            }
            objectMapper = new ObjectMapper();
            String tagsAsJson = objectMapper.writeValueAsString(tags);
            fullAdditionalProperties.put("tags", tagsAsJson);
        }
        if (!this.ingestIfNotExists.isEmpty()) {
            ObjectMapper objectMapper2 = new ObjectMapper();
            String ingestIfNotExistsJson = objectMapper2.writeValueAsString(this.ingestIfNotExists);
            fullAdditionalProperties.put("ingestIfNotExists", ingestIfNotExistsJson);
        }
        fullAdditionalProperties.putAll(this.additionalProperties);
        String mappingReference = this.ingestionMapping.getIngestionMappingReference();
        if (StringUtils.isNotBlank((CharSequence)mappingReference)) {
            fullAdditionalProperties.put("ingestionMappingReference", mappingReference);
            fullAdditionalProperties.put("ingestionMappingType", this.ingestionMapping.getIngestionMappingKind().toString());
        } else if (this.ingestionMapping.getColumnMappings() != null) {
            objectMapper = new ObjectMapper();
            objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
            objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            String mapping = objectMapper.writeValueAsString((Object)this.ingestionMapping.getColumnMappings());
            fullAdditionalProperties.put("ingestionMapping", mapping);
            fullAdditionalProperties.put("ingestionMappingType", this.ingestionMapping.getIngestionMappingKind().toString());
        }
        return fullAdditionalProperties;
    }

    public void setDataFormat(DATA_FORMAT dataFormat) {
        this.additionalProperties.put("format", dataFormat.name());
    }

    public void setDataFormat(String dataFormatName) {
        String dataFormat = DATA_FORMAT.valueOf(dataFormatName.toLowerCase()).name();
        if (!dataFormat.isEmpty()) {
            this.additionalProperties.put("format", dataFormat);
        }
    }

    public String getDataFormat() {
        return this.additionalProperties.get("format");
    }

    public void setIngestionMapping(String mappingReference, IngestionMapping.IngestionMappingKind ingestionMappingKind) {
        this.ingestionMapping = new IngestionMapping(mappingReference, ingestionMappingKind);
    }

    public void setIngestionMapping(ColumnMapping[] columnMappings, IngestionMapping.IngestionMappingKind ingestionMappingKind) {
        this.ingestionMapping = new IngestionMapping(columnMappings, ingestionMappingKind);
    }

    public void setIngestionMapping(IngestionMapping ingestionMapping) {
        this.ingestionMapping = ingestionMapping;
    }

    public IngestionMapping getIngestionMapping() {
        return this.ingestionMapping;
    }

    public void setAuthorizationContextToken(String token) {
        this.additionalProperties.put("authorizationContext", token);
    }

    void validate() {
        Ensure.stringIsNotBlank(this.databaseName, "databaseName");
        Ensure.stringIsNotBlank(this.tableName, "tableName");
        Ensure.argIsNotNull((Object)this.reportMethod, "reportMethod");
        if (this.ingestionMapping.getColumnMappings() != null) {
            Ensure.isFalse(StringUtils.isNotBlank((CharSequence)this.ingestionMapping.getIngestionMappingReference()), "Both mapping reference and column mappings were defined");
            IngestionMapping.IngestionMappingKind ingestionMappingKind = this.ingestionMapping.getIngestionMappingKind();
            for (ColumnMapping column : this.ingestionMapping.getColumnMappings()) {
                Ensure.isTrue(column.isValid(ingestionMappingKind), String.format("Column mapping '%s' is invalid", column.columnName));
            }
        }
    }

    public static enum IngestionReportMethod {
        Queue,
        Table,
        QueueAndTable;

    }

    public static enum IngestionReportLevel {
        FailuresOnly,
        None,
        FailuresAndSuccesses;

    }

    public static enum DATA_FORMAT {
        csv,
        tsv,
        scsv,
        sohsv,
        psv,
        txt,
        tsve,
        json,
        singlejson,
        multijson,
        avro,
        apacheavro,
        parquet,
        orc,
        raw;

    }
}

