/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest.result;

import com.microsoft.azure.kusto.ingest.result.IngestionResult;
import com.microsoft.azure.kusto.ingest.result.IngestionStatus;
import com.microsoft.azure.kusto.ingest.result.IngestionStatusInTableDescription;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.table.CloudTable;
import com.microsoft.azure.storage.table.TableOperation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;

public class TableReportIngestionResult
implements IngestionResult {
    private List<IngestionStatusInTableDescription> descriptors;

    public TableReportIngestionResult(List<IngestionStatusInTableDescription> descriptors) {
        this.descriptors = descriptors;
    }

    @Override
    public List<IngestionStatus> getIngestionStatusCollection() throws StorageException, URISyntaxException {
        LinkedList<IngestionStatus> results = new LinkedList<IngestionStatus>();
        for (IngestionStatusInTableDescription descriptor : this.descriptors) {
            CloudTable table = new CloudTable(new URI(descriptor.TableConnectionString));
            TableOperation operation = TableOperation.retrieve((String)descriptor.PartitionKey, (String)descriptor.RowKey, IngestionStatus.class);
            results.add((IngestionStatus)((Object)table.execute(operation).getResultAsType()));
        }
        return results;
    }

    @Override
    public int getIngestionStatusesLength() {
        return this.descriptors.size();
    }
}

