/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest.source;

import com.microsoft.azure.kusto.ingest.Ensure;
import com.microsoft.azure.kusto.ingest.source.AbstractSourceInfo;
import com.microsoft.azure.kusto.ingest.source.CompressionType;
import java.io.InputStream;
import java.util.Objects;
import java.util.UUID;

public class StreamSourceInfo
extends AbstractSourceInfo {
    private InputStream stream;
    private boolean leaveOpen = false;
    private CompressionType compressionType = null;

    public InputStream getStream() {
        return this.stream;
    }

    public void setStream(InputStream stream) {
        this.stream = Objects.requireNonNull(stream, "stream cannot be null");
    }

    public boolean isLeaveOpen() {
        return this.leaveOpen;
    }

    public void setLeaveOpen(boolean leaveOpen) {
        this.leaveOpen = leaveOpen;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public StreamSourceInfo(InputStream stream) {
        this.setStream(stream);
    }

    public StreamSourceInfo(InputStream stream, boolean leaveOpen) {
        this.setLeaveOpen(leaveOpen);
        this.setStream(stream);
    }

    public StreamSourceInfo(InputStream stream, boolean leaveOpen, UUID sourceId) {
        this.setLeaveOpen(leaveOpen);
        this.setStream(stream);
        this.setSourceId(sourceId);
    }

    @Override
    public void validate() {
        Ensure.argIsNotNull(this.stream, "stream");
        Ensure.isTrue(this.compressionType != CompressionType.zip, "streaming ingest is not working with zip compression");
    }

    public String toString() {
        return String.format("Stream with SourceId: %s", this.getSourceId());
    }
}

