/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.retry;

import com.microsoft.rest.retry.RetryStrategy;
import okhttp3.Response;

public final class ExponentialBackoffRetryStrategy
extends RetryStrategy {
    public static final int DEFAULT_CLIENT_BACKOFF = 10000;
    public static final int DEFAULT_MAX_BACKOFF = 30000;
    public static final int DEFAULT_MIN_BACKOFF = 1000;
    private final int deltaBackoff;
    private final int maxBackoff;
    private final int minBackoff;
    private final int retryCount;

    public ExponentialBackoffRetryStrategy() {
        this(10, 1000, 30000, 10000);
    }

    public ExponentialBackoffRetryStrategy(int retryCount, int minBackoff, int maxBackoff, int deltaBackoff) {
        this(null, retryCount, minBackoff, maxBackoff, deltaBackoff, true);
    }

    public ExponentialBackoffRetryStrategy(String name, int retryCount, int minBackoff, int maxBackoff, int deltaBackoff, boolean firstFastRetry) {
        super(name, firstFastRetry);
        this.retryCount = retryCount;
        this.minBackoff = minBackoff;
        this.maxBackoff = maxBackoff;
        this.deltaBackoff = deltaBackoff;
    }

    @Override
    public boolean shouldRetry(int retryCount, Response response) {
        int code = response.code();
        return retryCount < this.retryCount && (code == 408 || code >= 500 && code != 501 && code != 505);
    }
}

